/** Rozszerzenie klasy ProsteKolko, ktore moe si porusza 
 *  zgodnie z wartociami deltaX i deltaY. Przemieszczanie w danym 
 *  kierunku bdzie wykonywane do momentu, a krawd kka nie dotknie
 *  ciany, a wtedy kko "odbije si" i ruch bdzie kontynuowany 
 *  w kierunku przeciwnym.
 */

public class RuchomeKolko extends ProsteKolko {
  private int deltaX, deltaY;

  public RuchomeKolko(int x, int y, int promien, int deltaX,
                      int deltaY) {
    super(x, y, promien);
    this.deltaX = deltaX;
    this.deltaY = deltaY;
  }

  public void przesun(int szerokoscOkna, int wysokoscOkna) {
    ustawX(pobierzX() + pobierzDeltaX());
    ustawY(pobierzY() + pobierzDeltaY());
    odbijaj(szerokoscOkna, wysokoscOkna);
  }

  private void odbijaj(int szerokoscOkna, int wysokoscOkna) {
    int x = pobierzX(), y = pobierzY(), promien = pobierzPromien(),
        deltaX = pobierzDeltaX(), deltaY = pobierzDeltaY();
    if ((x - promien < 0) && (deltaX < 0)) {
      ustawDeltaX(-deltaX);
    } else if ((x + promien > szerokoscOkna) && (deltaX > 0)) {
      ustawDeltaX(-deltaX);
    }
    if ((y -promien < 0) && (deltaY < 0)) {
      ustawDeltaY(-deltaY);
    } else if((y + promien > wysokoscOkna) && (deltaY > 0)) {
      ustawDeltaY(-deltaY);
    }
  }

  public int pobierzDeltaX() {
    return(deltaX);
  }

  public void ustawDeltaX(int deltaX) {
    this.deltaX = deltaX;
  }

  public int pobierzDeltaY() {
    return(deltaY);
  }

  public void ustawDeltaY(int deltaY) {
    this.deltaY = deltaY;
  }
}
