import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

/** Aplet odbijajcy kka wok ekranu, wykorzystuje 
 *  podwjne buforowanie, aby zwikszy prdko rysowania 
 *  i unikn problemw przy nakadajcych si kkach.
 *  Metoda update zostaa nadpisana dla uniknicia 
 *  migotania obrazu.
 */

public class PodwojnieBuforowaneOdbijaj extends Applet implements
                                      Runnable, ActionListener {
  private Vector kolka;
  private int szerokosc, wysokosc;
  private Image pozaekranowyObrazek;
  private Graphics pozaekranowaGrafika;
  private Button przyciskStart, przyciskStop;
  private Thread watekAnimacji = null;

  public void init() {
    setBackground(Color.white);
    szerokosc = getSize().width;
    wysokosc = getSize().height;
    pozaekranowyObrazek = createImage(szerokosc, wysokosc);
    pozaekranowaGrafika = pozaekranowyObrazek.getGraphics();
    // W niektrych systemach automatyczne ale nie we wszystkich.
    pozaekranowaGrafika.setColor(Color.black);
    kolka = new Vector();
    przyciskStart = new Button("Dodaj nowe kko");
    przyciskStart.addActionListener(this);
    add(przyciskStart);
    przyciskStop = new Button("Zatrzymaj wszystkie kka");
    przyciskStop.addActionListener(this);
    add(przyciskStop);
  }

  /** Nacinicie przycisku "start" powoduje uruchomienie wtku animacji,
   *  jeeli nie jest on jeszcze uruchomiony. Niezalenie od tego, dodaj
   *  nowe kko do listy kek odbijanych po ekranie.
   *  <P>
   *  Nacinicie przycisku "stop" powoduje zatrzymanie wtku 
   *  i wyczyszczenie listy kek.
   */

  public void actionPerformed(ActionEvent zdarzenie) {
    if (zdarzenie.getSource() == przyciskStart) {
      if (kolka.size() == 0) {
        watekAnimacji = new Thread(this);
        watekAnimacji.start();
      }
      int promien = 25;
      int x = promien + losowaLiczba(szerokosc - 2 * promien);
      int y = promien + losowaLiczba(wysokosc - 2 * promien);
      int deltaX = 1 + losowaLiczba(10);
      int deltaY = 1 + losowaLiczba(10);
      kolka.addElement(new RuchomeKolko(x, y, promien, deltaX,
                                          deltaY));
      repaint();
    } else if (zdarzenie.getSource() == przyciskStop) {
      if (watekAnimacji != null) {
        watekAnimacji = null;
        kolka.removeAllElements();
      }
    }
  }

  /** W kadym przebiegu ptli przesu kka wzgldem ich
   *  biecego pooenia i wartoci deltaX/deltaY. Wartoci
   *  te s odwracane w momencie, kiedy kko dotrze do 
   *  krawdzi okna. 
   */

  public void run() {
    RuchomeKolko kolko;
    Thread mojWatek = Thread.currentThread();
    // Naprawd chodzi o powtarzanie dopki watekAnimacji nie bdzie rwny null.
    while(watekAnimacji==mojWatek) {
      for(int j=0; j<kolka.size(); j++) {
        kolko = (RuchomeKolko)kolka.elementAt(j);
        kolko.przesun(szerokosc, wysokosc);
      }
      repaint();
      pauza(100);
    }
  }

  /** Pomi normalnie wykonywany krok czyszczenia ekranu, aby unikn 
   *  migotania midzy kolejnymi odwieeniami ekranu.
   */

  public void update(Graphics g) {
    paint(g);
  }


  /** Wyczy pozaekranow map pikseli, narysuj na niej wszystkie kka,
   *  a nastpnie narysuj t map w oknie apletu.
   */

  public void paint(Graphics g) {
    pozaekranowaGrafika.clearRect(0, 0, szerokosc, wysokosc);
    RuchomeKolko kolko;
    for(int i=0; i<kolka.size(); i++) {
      kolko = (RuchomeKolko)kolka.elementAt(i);
      kolko.draw(pozaekranowaGrafika);
    }
    g.drawImage(pozaekranowyObrazek, 0, 0, this);
  }

  // Zwraca liczb cakowit od 0 do max (wcznie),
  // co daje max + 1 moliwych wartoci.

  private int losowaLiczba(int max) {
    double x = Math.floor((double)(max + 1) * Math.random());
    return((int)(Math.round(x)));
  }

  // Zanij na podany czas.

  private void pauza(int milisekund) {
    try {
      Thread.sleep((long)milisekund);
    } catch(InterruptedException ie) {}
  }
}
