import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

/** Aplet odbijajcy kka wok ekranu. Poniewa aplet nie wykorzystuje 
 *  podwjnego buforowania, ma problemy w przypadku nakadajcych 
 *  si kek. Metoda update zostaa nadpisana dla uniknicia 
 *  migotania obrazu.
 */

public class Odbijaj extends Applet implements Runnable,
                                              ActionListener {
  private Vector kolka;
  private int szerokosc, wysokosc;
  private Button przyciskStart, przyciskStop;
  private Thread watekAnimacji = null;

  public void init() {
    setBackground(Color.white);
    szerokosc = getSize().width;
    wysokosc = getSize().height;
    kolka = new Vector();
    przyciskStart = new Button("Dodaj nowe kko");
    przyciskStart.addActionListener(this);
    add(przyciskStart);
    przyciskStop = new Button("Zatrzymaj wszystkie kka");
    przyciskStop.addActionListener(this);
    add(przyciskStop);
  }

  /** Nacinicie przycisku "start" powoduje uruchomienie wtku animacji,
   *  jeeli nie jest on jeszcze uruchomiony. Niezalenie od tego, dodaj
   *  nowe kko do listy kek odbijanych po ekranie.
   *  <P>
   *  Nacinicie przycisku "stop" powoduje zatrzymanie wtku 
   *  i wyczyszczenie listy kek.
   */

  public void actionPerformed(ActionEvent zdarzenie) {
    if (zdarzenie.getSource() == przyciskStart) {
      if (kolka.size() == 0) {
        // Usu kka pozostae po poprzednim uruchomieniu.
        getGraphics().clearRect(0, 0, getSize().width,
                                      getSize().height);
        watekAnimacji = new Thread(this);
        watekAnimacji.start();
      }
      int promien = 25;
      int x = promien + losowaLiczba(szerokosc - 2 * promien);
      int y = promien + losowaLiczba(wysokosc - 2 * promien);
      int deltaX = 1 + losowaLiczba(10);
      int deltaY = 1 + losowaLiczba(10);
      kolka.addElement(new RuchomeKolko(x, y, promien, deltaX,
                                          deltaY));
    } else if (zdarzenie.getSource() == przyciskStop) {
      if (watekAnimacji != null) {
        watekAnimacji = null;
        kolka.removeAllElements();
      }
    }
    repaint();
  }

  /** W kadym przebiegu ptli wywoaj paint, a nastpnie zrb sobie krtk przerw. 
   *  Metoda paint przesuwa i rysuje kka. 
   */

  public void run() {
    Thread mojWatek = Thread.currentThread();
    // Naprawd chodzi o powtarzenie dopki watekAnimacji nie bdzie rwne null
    while(watekAnimacji==mojWatek) {
      repaint();
      pauza(100);
    }
  }

  /** Pomi normalnie wykonywany krok czyszczenia ekranu, aby unikn 
   *  migotania midzy kolejnymi odwieeniami ekranu.
   */

  public void update(Graphics g) {
    paint(g);
  }

  /** Usu poprzedni pozycj kadego kka, przesu je i narysuj 
   *  kko w nowym miejscu.
   */

  public void paint(Graphics g) {
    RuchomeKolko kolko;
    for(int i=0; i<kolka.size(); i++) {
      kolko = (RuchomeKolko)kolka.elementAt(i);
      g.setColor(getBackground());
      kolko.draw(g);  // Stara pozycja.
      kolko.przesun(szerokosc, wysokosc);
      g.setColor(getForeground());
      kolko.draw(g);  // Nowa pozycja.
    }
  }

  // Zwraca liczb cakowit od 0 do max (wcznie),
  // co daje max + 1 moliwych wartoci.

  private int losowaLiczba(int max) {
    double x =
      Math.floor((double)(max + 1) * Math.random());
    return((int)(Math.round(x)));
  }


  // Zanij na podany czas.

  private void pauza(int milisekund) {
    try {
      Thread.sleep((long)milisekund);
    } catch(InterruptedException ie) {}
  }
}
