/** Podklasa klasy Thread, ktra odlicza do podanej granicy
 *  przy losowych odstpach midzy krokami.
 */

public class Licznik extends Thread {
  private static int liczbaCalk = 0;
  private int numBiezacy, granicaPetli;

  public Licznik(int granicaPetli) {
    this.granicaPetli = granicaPetli;
    numBiezacy = liczbaCalk++;
  }

  private void pauza(double sekund) {
    try { Thread.sleep(Math.round(1000.0*sekund)); }
    catch(InterruptedException ie) {}
  }

  /** Wtek jest usuwany kiedy metoda run skoczy wykonywanie. */
  
  public void run() {
    for(int i=0; i<granicaPetli; i++) {
      System.out.println("Licznik " + numBiezacy + ": " + i);
      pauza(Math.random()); // Odczekaj nie wicej ni 1 sekund
    }
  }
}
