import java.math.BigInteger;

import cwp.LiczbyPierwsze;
import cwp.Pierwsze;

/** Oblicza publiczn par kluczy RSA przy minimalnej danej
 *  liczbie cyfr.
 */
 
public class KluczRSA {
  private static final BigInteger JEDEN = new BigInteger("1");

  // Okrela warto klucza szyfrujcego i deszyfrujcego.
  // Aby zaszyfrowa warto cakowit M, oblicz R = M^e mod N.
  // Aby odszyfrowa zaszyfrowan warto R, oblicz M = R^d mod N,
  // gdzie e jest kluczem publicznym, za d jest kluczem prywatnym.
  // Omwienie algorytmu zostao przedstawione w podrozdziale 7.4.3 
  // ksiki Weissa pt. Data Structures and Problem Solving with Java.

  public void obliczKlucz(String strLiczbaCyfr) {
    BigInteger p, q, n, m, szyfrujacy, deszyfrujacy;
    int liczbaCyfr = Integer.parseInt(strLiczbaCyfr);
    if (liczbaCyfr%2==1) {
      liczbaCyfr++;
    }
    do {
      p = Pierwsze.nastepnaPierwsza(Pierwsze.losowa(liczbaCyfr/2));
      q = Pierwsze.nastepnaPierwsza(Pierwsze.losowa(liczbaCyfr/2));

      n = p.multiply(q);
      m = (p.subtract(JEDEN)).multiply(q.subtract(JEDEN));

      // Znajd klucz szyfrujcy bdcy liczb pierwsz wzgldem m.
      szyfrujacy = Pierwsze.nastepnaPierwsza(Pierwsze.losowa(liczbaCyfr));
      while (!szyfrujacy.gcd(m).equals(JEDEN)) {
        szyfrujacy = Pierwsze.nastepnaPierwsza(szyfrujacy);
      }
      // Klucz deszyfrujcy jest odwrotnoci iloczynow klucza szyfrujcego modulo m.
      deszyfrujacy = szyfrujacy.modInverse(m);
    // Upewnij si, e klucz prywatny i publiczny maj dugos rwn liczbaCyfr.
    }while ((deszyfrujacy.toString().length() != liczbaCyfr) || 
            (szyfrujacy.toString().length() != liczbaCyfr) ||
            (n.toString().length() != liczbaCyfr));    
    System.out.println("\nN         => " + n);
    System.out.println("publiczny  => " + szyfrujacy);
    System.out.println("prywatny   => " + deszyfrujacy);
  }
}
