import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/** Rysuje "gumowe" prostokty, kiedy uytkownik przeciga
 *  mysz po ekranie.
 */

public class GumowyProstokat extends Applet {
  private int poczatekX, poczatekY, poprzednieX, poprzednieY;

  public void init() {
    addMouseListener(new RejestratorProstokatow());
    addMouseMotionListener(new RysownikProstokatow());
    setBackground(Color.white);
  }

  /** Rysuje prostokt dobierajc jego wsprzdne x, y, w, h
   *  tak, aby poprawnie dostosowa pozycj przeciwlegego wierzchoka 
   *  prostokta wzgldem pozycji pocztkowej.
   */

  private void narysujProstokat(Graphics g, int poczatekX, int poczatekY,
                             int koniecX, int koniecY ) {
    int x, y, w, h;
    x = Math.min(poczatekX, koniecX);
    y = Math.min(poczatekY, koniecY);
    w = Math.abs(poczatekX - koniecX);
    h = Math.abs(poczatekY - koniecY);
    g.drawRect(x, y, w, h);
  }

  private class RejestratorProstokatow extends MouseAdapter {

    /** W momencie nacinicia przycisku myszy, zapamituje
     *  pooenie lewego-grnego wierzchoka prostokta.
     */

    public void mousePressed(MouseEvent zdarzenie) {
      poczatekX = zdarzenie.getX();
      poczatekY = zdarzenie.getY();
      poprzednieX = poczatekX;
      poprzednieY = poczatekY;
    }

    /** Usu ostatni prostokt w momencie, kiedy uytkownik
     *  zwolni klawisz myszy.
     */

    public void mouseReleased(MouseEvent zdarzenie) {
      Graphics g = getGraphics();
      g.setPaintMode();
      narysujProstokat(g, poczatekX, poczatekY, poprzednieX, poprzednieY);
    }
  } 

  private class RysownikProstokatow extends MouseMotionAdapter {

    /** Rysuje gumowy prostokt od miejsca, w ktrym 
     *  klawisz myszy zosta nacinity, do miejsca,
     *  do ktrego mysz zostaa przecignita.
     */

    public void mouseDragged(MouseEvent zdarzenie) {
      int x = zdarzenie.getX();
      int y = zdarzenie.getY();

      Graphics g = getGraphics();
      g.setXORMode(Color.lightGray);
      narysujProstokat(g, poczatekX, poczatekY, poprzednieX, poprzednieY);
      narysujProstokat(g, poczatekX, poczatekY, x, y);

      poprzednieX = x;
      poprzednieY = y;
    }
  } 
}
