import java.applet.Applet;
import java.awt.*;

/** Duke jest podklas klasy Thread, ktra zna swj macierzysty aplet
 *  (silne powizanie), dziki czemu moe wywoywa metod repaint 
 *  rodzica. Klasa Duke jest odpowiedzialna przede wszystkim za 
 *  zmienianie wartoci indeksu w tablicy obrazkw.
 */

public class Duke extends Thread {
  public static final int ZATRZYMAJ = 0;
  public static final int WYKONUJ   = 1;
  public static final int CZEKAJ    = 2;

  public static Image[] obrazki;
  private static final int LICZBAOBRAZKOW = 15;
  private static Object blokada = new Object();
  private int stan = WYKONUJ;
  private int kierunekFikolka;
  private int indeks = 0;
  private Applet rodzic;

  public Duke(int kierunekFikolka, Applet rodzic) {
    this.kierunekFikolka = kierunekFikolka;
    this.rodzic = rodzic;
    synchronized(blokada) {
      if (obrazki==null) {  // Jeli nie byy wczeniej zaadowane.
        obrazki = new Image[ LICZBAOBRAZKOW ];
        for (int i=0; i<LICZBAOBRAZKOW; i++) {
          obrazki[i] = rodzic.getImage( rodzic.getCodeBase(),
                                       "images/T" + i + ".gif");
        }
      }
    }
  }

  /** Zwraca biec warto indeksu w tablicy obrazkw.  */

  public int pobierzIndeks() { return indeks; }

  /** Metoda publiczna umoliwiajca ustawianie flagi zatrzymujcej 
   *  lub zawieszajcej wtek. Stan jest monitorowany przez 
   *  metod sprawdzStan.
   */

  public synchronized void ustawStan(int stan) {
    this.stan = stan;
    if (stan==WYKONUJ) {
      notify();
    }
  }

  /** Zwraca biecy stan wtku (WYKONUJ, ZATRZYMAJ, CZEKAJ). 
   *  Jeeli wtek ma pozosta zawieszony, to do momentu, 
   *  a stan nie zostanie zmieniony przez wywoanie publicznej
   *  metody ustawStan, na wtku na okrgo wywoywana jest metoda wait.
   */

  private synchronized int sprawdzStan() {
    while (stan==CZEKAJ) {
      try {
        wait();
      } catch (InterruptedException e) {}
    }
    return stan;
  }

  /** Przy kadym powtrzeniu ptli while wtek kolejno zmienia 
   *  warto zmiennej indeks (w tablicy obrazkw), wywouje metod 
   *  repaint i na chwil si zatrzymuje. Przy kadym powtrzeniu 
   *  ptli sprawdzany jest stan (flaga) wtku.
   */

  public void run() {
    while (sprawdzStan()!=ZATRZYMAJ) {
      indeks += kierunekFikolka;
      if (indeks < 0) {
        indeks = LICZBAOBRAZKOW - 1;
      }
      if (indeks >= LICZBAOBRAZKOW) {
        indeks = 0;
      }

      rodzic.repaint();

      try {
        Thread.sleep(100);
      } catch (InterruptedException e) {
        break;   // Przerwij ptl while.
      }
    }
  }
}
