import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** Klasa CzasomierzowyDuke uatwia animacj dziki utworzeniu
 *  wewntrznego czasomierza. Wyzwolenie czasomierza powoduje
 *  zasygnalizowanie zdarzenia do metody actionPerformed,
 *  ktra z kolei wywouje metod repaint macierzystego apletu.
 */

public class CzasomierzowyDuke implements ActionListener {
  private static final int LICZBAOBRAZKOW = 15;
  private static boolean zaladowane = false;
  private static Object blokada = new Object();
  private int kierunekFikolka;
  private int msec;
  private int indeks = 0;
  private Applet rodzic;
  private Timer czasomierz;
  public static Image[] obrazki = new Image[LICZBAOBRAZKOW];

  public CzasomierzowyDuke(int kierunekFikolka, int msec,
                                        Applet rodzic) {
    this.kierunekFikolka = kierunekFikolka;
    this.msec = msec;
    this.rodzic = rodzic;

    synchronized (blokada) {
      if (!zaladowane) {
         MediaTracker tropiciel = new MediaTracker(rodzic);
         for (int i=0; i<LICZBAOBRAZKOW; i++) {
           obrazki[i] = rodzic.getImage(rodzic.getCodeBase(),
                                       "images/T" + i + ".gif");
           tropiciel.addImage(obrazki[i],0);
         }
         try {
           tropiciel.waitForAll();
         } catch (InterruptedException ie) {}
         if (!tropiciel.isErrorAny()) {
           zaladowane = true;
         }
      }
    }

    czasomierz = new Timer(msec, this);
  }

  // Zwraca biec warto indeksu w tablicy obrazkw.  

  public int pobierzIndeks() { return indeks; }

  // Otrzymuje zdarzenie czasomierza. Zwiksza indeks w tablicy
  // obrazkw i wymusza narysowanie nowego obrazka.

  public void actionPerformed(ActionEvent event) {
    indeks += kierunekFikolka;
    if (indeks < 0){
      indeks = LICZBAOBRAZKOW - 1;
    }
    if (indeks >= LICZBAOBRAZKOW) {
      indeks = 0;
    }
    rodzic.repaint();
  }

  // Usuga publiczna umoliwiajca uruchomienie czasomierza.
  public void uruchomCzasomierz() {
    czasomierz.start();
  }

  // Usuga publiczna umoliwiajca zatrzymanie czasomierza.
  public void zatrzymajCzasomierz() {
    czasomierz.stop();
  }
}
