import java.applet.Applet;
import java.awt.*;

public class AnimacjaObrazkow extends Applet {

/** Odwiedza kolejno przez tablic 15 obrazkw wykonujc ich 
 *  animacj. Odrbny wtek nadzoruje kadego fikajcego Duka.
 *  Metoda stop apletu wywouje publiczn usug klasy 
 *  Duke, aby zakoczy wtek. Metoda update zostaa nadpisana
 *  dla uniknicia migotania obrazu.
 */

  private static final int LICZBADUKOW  = 2;
  private Duke[] duki;
  private int i;

  public void init() {
    duki = new Duke[LICZBADUKOW];
    setBackground(Color.white);
  }


  /** Uruchom wszystkie wtki, podajc kierunek przechodzenia 
   *  w sekwencji obrazkw.
   */

  public void start() {
    int kierunekFikolka;
    for (int i=0; i<LICZBADUKOW ; i++) {
      kierunekFikolka = (i%2==0) ? 1 :-1;
      duki[i] = new Duke(kierunekFikolka, this);
      duki[i].start();
    }
  }


  /** Pomi normalnie wykonywany krok czyszczenia ekranu, aby unikn 
   *  migotania midzy kolejnymi odwieeniami ekranu.
   */

  public void update(Graphics g) {
    paint(g);
  }

  public void paint(Graphics g) {
    for (i=0 ; i<LICZBADUKOW ; i++) {
      if (duki[i] != null) {
        g.drawImage(Duke.obrazki[duki[i].pobierzIndeks()],
                    200*i, 0, this);
      }
    }
  }

  /** Wywoanie metody stop Apletu spowoduje uycie publicznie 
   *  dostpnej usugi ustawStan klasy Duke do ustawienia flagi
   *  i zakoczenia metody run wtku. 
   */

  public void stop() {
    for (int i=0; i<LICZBADUKOW ; i++) {
      if (duki[i] != null) {
        duki[i].ustawStan(Duke.ZATRZYMAJ);
      }
    }
  }
}
