import java.awt.*;
import javax.swing.*;

/** Przykad animacji zaimplementowanej przy uyciu czasomierzy Swing.
 *  Tworzone s dwie postacie Duke, kady z innym okresem czasomierza.
 */

public class AnimacjaCzasomierzami extends JApplet {
  private static final int LICZBADUKOW = 2;
  private CzasomierzowyDuke[] duki;
  private int i, indeks;

  public void init() {
    duki = new CzasomierzowyDuke[LICZBADUKOW];
    setBackground(Color.white);
    duki[0] = new CzasomierzowyDuke( 1, 100, this);
    duki[1] = new CzasomierzowyDuke(-1, 500, this);

  }

  //  Uruchom czasomierze kadego Duka.

  public void start() {
    for (int i=0; i<LICZBADUKOW ; i++) {
      duki[i].uruchomCzasomierz();
    }
  }

  public void paint(Graphics g) {
    for (i=0 ; i<LICZBADUKOW ; i++) {
      if (duki[i] != null) {
        indeks = duki[i].pobierzIndeks();
        g.drawImage(CzasomierzowyDuke.obrazki[indeks], 200*i, 0, this);
      }
    }
  }

  //  Zatrzymaj czasomierz kadego Duka.

  public void stop() {
    for (int i=0; i<LICZBADUKOW ; i++) {
      duki[i].zatrzymajCzasomierz();
    }
  }
}
