import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;

/** Drzewo JTree zgaszajcy wybr wierzchoka przez umieszczenie jego 
 *  wartoci tekstowej w polu JTextField.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class WybieralneDrzewo extends JFrame
                            implements TreeSelectionListener {
  public static void main(String[] args) {
    new WybieralneDrzewo();
  }

  private JTree drzewo;
  private JTextField poleBiezacegoWyboru;
  
  public WybieralneDrzewo() {
    super("Wybieranie wierzchokw");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();
    DefaultMutableTreeNode korzen =
      new DefaultMutableTreeNode("Korze");
    DefaultMutableTreeNode dziecko;
    DefaultMutableTreeNode wnuk;
    for(int indeksDziecka=1; indeksDziecka<4; indeksDziecka++) {
      dziecko = new DefaultMutableTreeNode("Dziecko " + indeksDziecka);
      korzen.add(dziecko);
      for(int indeksWnuka=1; indeksWnuka<4; 
           indeksWnuka++) {
        wnuk =
          new DefaultMutableTreeNode("Wnuk " + indeksDziecka +
                                     "." + indeksWnuka);
        dziecko.add(wnuk);
      }
    }
    drzewo = new JTree(korzen);
    drzewo.addTreeSelectionListener(this);
    zawartosc.add(new JScrollPane(drzewo), BorderLayout.CENTER);
    poleBiezacegoWyboru = 
      new JTextField("Aktualnie wybrany: BRAK");
    zawartosc.add(poleBiezacegoWyboru, BorderLayout.SOUTH);
    setSize(250, 275);
    setVisible(true);
  }

  public void valueChanged(TreeSelectionEvent zdarzenie) {
    Object wybrany = drzewo.getLastSelectedPathComponent();
    if (wybrany != null) {
      poleBiezacegoWyboru.setText
        ("Aktualnie wybrany: " + wybrany.toString());
    }
  }
}