import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;

/** Prosty wierzchoek drzewa, ktrego dzieci s dodawane w locie.
 *  Wykorzystano fakt, e metoda getChildCount jest zawsze wywoywana
 *  przed faktycznym odwoaniem si do ktrego kolwiek z dzieci. 
 *  Dziki temu getChildCount moe wygenerowa dzieci jeli do tej
 *  pory istniay. 
 *  <P>
 *  W tym przykadzie tworzone jest proste drzewo "spisu treci".
 *  Oznacza to, e jeli biecym wierzchokiem jest "x" to jego 
 *  dziemi bd "x.0", "x.1", "x.2" i "x.3".
 *  <P>
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class WierzcholekSpisu extends DefaultMutableTreeNode {
  private boolean czyDzieciZdefiniowane = false;
  private int pozycjaSpisu;
  private int liczbaDzieci;

  public WierzcholekSpisu(int pozycjaSpisu, int liczbaDzieci) {
    this.pozycjaSpisu = pozycjaSpisu;
    this.liczbaDzieci = liczbaDzieci;
  }
  
  public boolean isLeaf() {
    return(false);
  }

  public int getChildCount() {
    if (!czyDzieciZdefiniowane) {
      zdefiniujWierzcholkiDzieci();
    }
    return(super.getChildCount());
  }

  private void zdefiniujWierzcholkiDzieci() {
    // Jeli do dodawania dzieci stosowana jest metoda "add"
	// to konieczne jest ustawienie flagi przed dodaniem dzieci,
	// W przeciwnym przypadku wystpiaby nieskoczone ptla rekursji
	// poniewa "add" powoduje wywoanie metody getChildCount.
	// Zamiast tego mona uy metod "insert".
    czyDzieciZdefiniowane = true;
    for(int i=0; i<liczbaDzieci; i++) {
      add(new WierzcholekSpisu(i+1, liczbaDzieci));
    }
  }

  public String toString() {
    TreeNode rodzic = getParent();
    if (rodzic == null) {
      return(String.valueOf(pozycjaSpisu));
    } else {
      return(rodzic.toString() + "." + pozycjaSpisu);
    }
  }
}