import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;

/** Przykadowe drzewo zbudowane z wierzchokw typu DefaultMutableTreeNodes. 
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class ProsteDrzewo extends JFrame {
  public static void main(String[] args) {
    new ProsteDrzewo();
  }
 
  public ProsteDrzewo() {
    super("Tworzenie prostego drzewa JTree");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();
    Object[] hierarchia =
      { "javax.swing",
        "javax.swing.border",
        "javax.swing.colorchooser",
        "javax.swing.event",
        "javax.swing.filechooser",
        new Object[] { "javax.swing.plaf",
                       "javax.swing.plaf.basic",
                       "javax.swing.plaf.metal",
                       "javax.swing.plaf.multi" },
        "javax.swing.table",
        new Object[] { "javax.swing.text",
                       new Object[] { "javax.swing.text.html",
                                     "javax.swing.text.html.parser" },
                       "javax.swing.text.rtf" },
        "javax.swing.tree",
        "javax.swing.undo" };
    DefaultMutableTreeNode korzen = przeksztalcHierarchie(hierarchia);
    JTree drzewo = new JTree(korzen);
    zawartosc.add(new JScrollPane(drzewo), BorderLayout.CENTER);
    setSize(275, 300);
    setVisible(true);
  }

  /** Prosta procedura, ktra utworzy wierzchoek na podstawie 
   *  pierwszego elementu tablicy, a nastpnie stworzy wierzchoki
   *  z pozostaych elementw i uczyni je potomkami pierwszego.
   *  Proces jest powtarzany rekursywnie dla elementw bdcych 
   *  tablicami. 
   */

  private DefaultMutableTreeNode przeksztalcHierarchie(
                                           Object[] hierarchia) {
    DefaultMutableTreeNode wierzcholek =
      new DefaultMutableTreeNode(hierarchia[0]);
    DefaultMutableTreeNode potomek;
    for(int i=1; i<hierarchia.length; i++) {
      Object opisWierzcholka = hierarchia[i];
      if (opisWierzcholka instanceof Object[]) { //Wierzchoek ma potomkw
        potomek = przeksztalcHierarchie((Object[])opisWierzcholka);
      } else {
        potomek = new DefaultMutableTreeNode(opisWierzcholka); //Li
      }
      wierzcholek.add(potomek);
    }
    return(wierzcholek);
  }
}