import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;

/** Drzewo JTree, ktrego wierzchoki nie maj ikon 
 *  albo wywietlaj niestandardowe ikony. 
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class NiestandardoweIkony extends JFrame {
  public static void main(String[] args) {
    new NiestandardoweIkony();
  }

  private Icon mojaIkonaOtwarty = 
            new ImageIcon("images/Circle_1.gif");
  private Icon mojaIkonaZamkniety = 
            new ImageIcon("images/Circle_2.gif");
  private Icon mojaIkonaLisc = 
            new ImageIcon("images/Circle_3.gif");
  
  public NiestandardoweIkony() {
    super("Niestandardowe ikony w drzewie JTree");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();
    zawartosc.setLayout(new FlowLayout());
    DefaultMutableTreeNode korzen =
      new DefaultMutableTreeNode("Korze");
    DefaultMutableTreeNode dziecko;
    DefaultMutableTreeNode wnuk;
    for(int indeksDziecka=1; indeksDziecka<4; indeksDziecka++) {
      dziecko = new DefaultMutableTreeNode("Dziecko " + indeksDziecka);
      korzen.add(dziecko);
      for(int indeksWnuka=1; indeksWnuka<4; 
                             indeksWnuka++) {
        wnuk =
          new DefaultMutableTreeNode("Wnuk " + indeksDziecka +
                                     "." + indeksWnuka);
        dziecko.add(wnuk);
      }
    }
    JTree drzewo1 = new JTree(korzen);
    drzewo1.expandRow(1);    // Rozwi dzieci aby zademonstrowa ikony lici.
    JScrollPane panel1 = new JScrollPane(drzewo1);
    panel1.setBorder(
            BorderFactory.createTitledBorder("Standardowe ikony"));
    zawartosc.add(panel1);

    JTree drzewo2 = new JTree(korzen);
    // Rozwi dzieci aby zademonstrowa ikony lici.
    drzewo2.expandRow(2); 
    DefaultTreeCellRenderer wyswietlacz2 = 
                              new DefaultTreeCellRenderer();
    wyswietlacz2.setOpenIcon(null);
    wyswietlacz2.setClosedIcon(null);
    wyswietlacz2.setLeafIcon(null);
    drzewo2.setCellRenderer(wyswietlacz2);
    JScrollPane panel2 = new JScrollPane(drzewo2);
    panel2.setBorder(
            BorderFactory.createTitledBorder("Bez ikon"));
    zawartosc.add(panel2);

    JTree drzewo3 = new JTree(korzen);
    // Rozwi dzieci aby zademonstrowa ikony lici.
    drzewo3.expandRow(3); 
    DefaultTreeCellRenderer wyswietlacz3 = 
                              new DefaultTreeCellRenderer();
    wyswietlacz3.setOpenIcon(mojaIkonaOtwarty);
    wyswietlacz3.setClosedIcon(mojaIkonaZamkniety);
    wyswietlacz3.setLeafIcon(mojaIkonaLisc);
    drzewo3.setCellRenderer(wyswietlacz3);
    JScrollPane panel3 = new JScrollPane(drzewo3);
    panel3.setBorder(
           BorderFactory.createTitledBorder("Wasne ikony"));
    zawartosc.add(panel3);

    pack();
    setVisible(true);
  }
}