import java.awt.*;
import javax.swing.*;

/** Przykadowe drzewo, ktrego wierzchoki s dodawane w locie.
 *  Wicej informacji znajdziesz w opisie klasy WierzcholekSpisu.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class DynamiczneDrzewo extends JFrame {
  public static void main(String[] args) {
    int n = 5; // Liczba potomkw dla kadego wierzchoka.
    if (args.length > 0) {
      try {
        n = Integer.parseInt(args[0]);
      } catch(NumberFormatException nfe) {
        System.out.println(
          "Bd w zapisie liczby -- uyta bdzie warto domylna " + n);
      }
   }
    new DynamiczneDrzewo(n);
  }
 
  public DynamiczneDrzewo(int n) {
    super("Tworzenie dynamicznego drzewa JTree");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();
    JTree drzewo = new JTree(new WierzcholekSpisu(1, n));
    zawartosc.add(new JScrollPane(drzewo), BorderLayout.CENTER);
    setSize(300, 475);
    setVisible(true);
  }
}