import java.awt.*;
import java.text.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

/** Tabela JTable reagujca na zdarzenia TableModelEvent
 *  i uaktualniajca inne komrki tabeli w odpowiedzi 
 *  na wartoci wprowadzane przez uytkownika.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class ZdarzeniaTabeli extends JFrame {
  private final int KOLUMNA_CENA     = 1;
  private final int KOLUMNA_ILOSC     = 2;
  private final int KOLUMNA_SUMA      = 3;
  private final int WIERSZ_OSTATNI    = 5;
  private DecimalFormat df = new DecimalFormat("####.## z");
  private JTable przykladowaTabela;
  private DefaultTableModel modelTabeli;

  public static void main(String[] args) {
    new ZdarzeniaTabeli();
  }

  public ZdarzeniaTabeli() {
    super("Wykorzystanie zdarze tabeli");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();

    String[] nazwyKolumn = { "Ksika", "Cena", "Ilo", "Suma" };

    final Object[][] dane = {
      {"Serwisy internetowe. Programowanie.",   "3,99 z", "0", "0,00 z"},
      {"Serwlety i JSP",                      "139,99 z", "0", "0,00 z"},
      {"Java Swing",                          "159,99 z", "0", "0,00 z"},
      {"Java, Tom I",                         "129,49 z", "0", "0,00 z"},
      {"Java, Tom II",                        "139,99 z", "0", "0,00 z"},
      {null, null,                                    "Razem:", "0,00 z"} };

    modelTabeli = new DefaultTableModel(dane, nazwyKolumn);
    modelTabeli.addTableModelListener(
      new TableModelListener() {
        int wiersz, kolumna;
        int ilosc;
        float cena, sumaCzesc, sumaCalk;
        public void tableChanged(TableModelEvent zdarzenie) {
          wiersz = zdarzenie.getFirstRow();
          kolumna = zdarzenie.getColumn();
          // Uaktualnij tabel tylko jeeli zmianiona zostaa ilo zamawianych ksiek.
          if (kolumna == KOLUMNA_ILOSC) {
            try {
              cena = odczytajSformatowanaWartoscKomorki(wiersz, KOLUMNA_CENA);
              ilosc = odczytajWartoscKomorkiIlosc(wiersz, KOLUMNA_ILOSC);
              sumaCzesc = ilosc * cena;

              // Uaktualnij sum w wierszu.
              modelTabeli.setValueAt(df.format(sumaCzesc),
                                    wiersz, KOLUMNA_SUMA);
              // Uaktualnij sum cakowit.
              sumaCalk=0;
              for(int wiersz=0; wiersz<dane.length-1; wiersz++) {
                sumaCalk += odczytajSformatowanaWartoscKomorki(wiersz, KOLUMNA_SUMA);
              }
              modelTabeli.setValueAt(df.format(sumaCalk),
                                    WIERSZ_OSTATNI,KOLUMNA_SUMA);
              modelTabeli.fireTableDataChanged();
            } catch (NumberFormatException nfe) {
                // Wywietl uytwkonikow komunikat o bdzie.
                JOptionPane.showMessageDialog(
                             ZdarzeniaTabeli.this,
                             "Wprowadzono nieprawidow warto!");
            }
          }
        }

        private float odczytajSformatowanaWartoscKomorki(int wiersz, int kolumna) {
          String tekst = (String)modelTabeli.getValueAt(wiersz, kolumna);
		  Number wartosc = df.parse(tekst,new ParsePosition(0)); 
		  if (wartosc == null) throw new NumberFormatException();
          return (wartosc.floatValue());
        }

		private int odczytajWartoscKomorkiIlosc(int wiersz, int kolumna) {
          String tekst = (String)modelTabeli.getValueAt(wiersz, kolumna);
		  return(Integer.parseInt(tekst));
		}

      });

    przykladowaTabela = new JTable(modelTabeli);
    ustawWyrownanieKolumn(przykladowaTabela.getColumnModel());
    JScrollPane panelTabeli = new JScrollPane(przykladowaTabela);

    zawartosc.add(panelTabeli, BorderLayout.CENTER);
    setSize(460,150);
    setVisible(true);
  }

  // Wyrwnaj do prawej wszystkie poza pierwsz tabel.
  private void ustawWyrownanieKolumn(TableColumnModel tcm) {
    TableColumn kolumna;
    DefaultTableCellRenderer wyswietlacz =
      new DefaultTableCellRenderer();
    for(int i=1; i<tcm.getColumnCount(); i++) {
      kolumna = tcm.getColumn(i);
      wyswietlacz.setHorizontalAlignment(SwingConstants.RIGHT);
      kolumna.setCellRenderer(wyswietlacz);
    }
  }
}