import java.awt.*;
import javax.swing.*;

/** Przykad prostej tabeli JTable w ktrej nagwek i dane tabeli 
 *  reprezentowane s przez tablice acuchw tekstowych.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class PrzykladProstejTabeli extends JFrame {
  public static void main(String[] args) {
    new PrzykladProstejTabeli();
  }

  private final int KOLUMNY = 4;
  private final int WIERSZE = 15;
  private JTable przykladowaTabela;

  public PrzykladProstejTabeli() {
    super("Tworzenie prostej tabeli JTable");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();

    String[]   nazwyKolumn   = generujNazwyKolumn(KOLUMNY);
    String[][] komorkiTabeli = generujKomorkiTabeli(WIERSZE, KOLUMNY);

    przykladowaTabela = new JTable(komorkiTabeli, nazwyKolumn);
    JScrollPane tablePane = new JScrollPane(przykladowaTabela);
    zawartosc.add(tablePane, BorderLayout.CENTER);
    setSize(450,150);
    setVisible(true);
  }

  private String[] generujNazwyKolumn(int kolumny) {
    String[] naglowek = new String[kolumny];
    for(int i=0; i<kolumny; i++) {
      naglowek[i] = "Kolumna " + i;
    }
    return(naglowek);
  }

  private String[][] generujKomorkiTabeli(int wiersze, int kolumny) {
    String[][] komorki = new String[wiersze][kolumny];
    for(int i=0; i<wiersze ; i++) {
      for(int j=0; j<kolumny; j++ ) {
        komorki[i][j] = "Wiersz " + i + ", Kolumna " + j;
      }
    }
    return(komorki);
  }
}