import java.util.Vector;
import javax.swing.*;
import javax.swing.table.*;

/** Tabela JTable wykorzustujca model DefaultTableModel, ktry
 *  umoliwia programowe dodawanie kolumn i wierszy.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class PrzykladDomyslnejTabeli extends JTable {
  
  private String[] nazwyKolumn = 
    { "Flaga", "Miasto", "Pastwo", "Komentarz", "Odwiedzone" };

  public PrzykladDomyslnejTabeli() {
    this(new DefaultTableModel());
  }
    
  public PrzykladDomyslnejTabeli(DefaultTableModel model) {
    super(model);
    
    KolekcjaMiejscowosciJava kolekcja =
      new KolekcjaMiejscowosciJava();
    MiejscowoscJava[] miejscowosci = kolekcja.podajMiejscowosci();

    // Ustaw nazwy kolumn oraz dane dla modelu tabeli.
    int i;
    for(i=0; i<nazwyKolumn.length; i++ ) {
      model.addColumn(nazwyKolumn[i]); 
    }
    for(i=0; i<miejscowosci.length; i++) {
      model.addRow(podajDaneWiersza(miejscowosci[i]));
    }
  }

  private Vector podajDaneWiersza(MiejscowoscJava miejscowosc) {
    Vector wektor = new Vector();
    wektor.add(new ImageIcon(miejscowosc.podajPlikFlagi()));
    wektor.add("Java");
    wektor.add(miejscowosc.podajPanstwo());
    wektor.add(miejscowosc.podajKomentarz());
    wektor.add(new Boolean(false));
    return(wektor);
  }
  
  public static void main(String[] args) {
    NarzedziaOkienkowe.ustawWygladSystemowy();
    NarzedziaOkienkowe.otworzWJFrame(
       new JScrollPane(new PrzykladDomyslnejTabeli()), 600, 150, 
                       "Stosowanie domylnego modelu tabeli");
  }
}