import javax.swing.table.*;

/** Rozszerzenie klasy DefaultTableModel, w ktrym zwracany jest typ danych 
 *  w kolumnie umoliwiajcy dobranie odpowiedniego wywietlacza komrek.
 *  Uytkownik moe edytowa tylko kolumny Komentarz i Odwiedzone.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class NiestandardowyModelTabeli extends DefaultTableModel {
  
  public Class getColumnClass(int kolumna) {
    return(getValueAt(0, kolumna).getClass());
  }

  // Tylko kolumny "Komentarz" i "Odwiedzone" mog by edytowane.
  public boolean isCellEditable(int wiersz, int kolumna) {
    return(kolumna==3 || kolumna==4);
  }
}