/** Prosta kolekcja przechowujca w tablicy wiele obiektw typu 
 *  MiejscowoscJava i potrafica okreli liczb unikalnych 
 *  pastw reprezentowanych w przekazanych danych.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class KolekcjaMiejscowosciJava {
  private static MiejscowoscJava[] standardoweMiejscowosci =
    { new MiejscowoscJava("Belgia",
                          "blisko Liege",
                          "flags/belgium.gif"),
      new MiejscowoscJava("Brazylia",
                          "blisko Salvador",
                          "flags/brazil.gif"),
      new MiejscowoscJava("Filipiny",
                          "blisko Quezon City",
                          "flags/philippines.gif"),
      new MiejscowoscJava("Hiszpania",
                          "blisko Viana de Bolo",
                          "flags/spain.gif"),
      new MiejscowoscJava("Kolumbia",
                          "blilsko Bogoty",
                          "flags/colombia.gif"),
      new MiejscowoscJava("Indonezja",
                          "gwna wyspa",
                          "flags/indonesia.gif"),
      new MiejscowoscJava("Jamajka",
                          "blisko Spanish Town",
                          "flags/jamaica.gif"),
      new MiejscowoscJava("Mozambik",
                          "blisko Sofali",
                          "flags/mozambique.gif"),
      new MiejscowoscJava("Sao Tome",
                          "blisko Santa Cruz",
                          "flags/saotome.gif"),
      new MiejscowoscJava("Stany Zjednoczone",
                          "blisko Montgomery, Alabama",
                          "flags/usa.gif"),
      new MiejscowoscJava("Stany Zjednoczone",
                          "blisko Needles, Kalifornia",
                          "flags/usa.gif"),
      new MiejscowoscJava("Stany Zjednoczone",
                          "blisko Dallas, Texas",
                          "flags/usa.gif"),
      new MiejscowoscJava("Surinam",
                          "blisko Paramibo",
                          "flags/suriname.gif")
    };

  private MiejscowoscJava[] miejscowosci;
  private int liczbaPanstw;

  public KolekcjaMiejscowosciJava(MiejscowoscJava[] miejscowosci) {
    this.miejscowosci = miejscowosci;
    this.liczbaPanstw = policzPanstwa(miejscowosci);
  }
  
  public KolekcjaMiejscowosciJava() {
    this(standardoweMiejscowosci);
  }

  public MiejscowoscJava[] podajMiejscowosci() {
    return(miejscowosci);
  }

  public int podajLiczbePanstw() {
    return(liczbaPanstw);
  }

  // Zlicza liczb unikalnych pastw reprezentowanych w danych.
  // Zakada, e lista jest posortowana wzgldem nazwy pastwa.
  private int policzPanstwa(MiejscowoscJava[] miejscowosci) {
    int n = 0;
    String biezacePanstwo, poprzedniePanstwo = "Zadne";
    for(int i=0;i<miejscowosci.length;i++) {
      biezacePanstwo = miejscowosci[i].podajPanstwo();
      if (!poprzedniePanstwo.equals(biezacePanstwo)) {
        n++;
     }
      biezacePanstwo = poprzedniePanstwo;
    }
    return(n);
  }
}