import java.awt.*;
import javax.swing.*;
import java.awt.geom.*;

/** Okno posiadajce indywidualn metod paintComponent. 
 *  Ilustruje, e mona stworzy ogln metod 
 *  drukujc dowolny komponent, niezalenie od tego 
 *  czy ten komponent jest indywidualnie rysowany.
 *  Klasa NarzedziaWydruku zawiera metod  drukujKomponent
 *  umoliwiajc wydrukowanie dowolnego komponentu 
 *  przez wywoanie tylko jednej funkcji.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class RysowanyPanel extends JPanel {
  private int rozmiarCzcionki = 90;
  private String komunikat = "Java 2D";
  private int szerokoscKomunikatu;
  
  public RysowanyPanel() {
    setBackground(Color.white);
    Font czcionka = new Font("Serif", Font.PLAIN, rozmiarCzcionki);
    setFont(czcionka);
    FontMetrics metryka = getFontMetrics(czcionka);
    szerokoscKomunikatu = metryka.stringWidth(komunikat);
    int szerokosc = szerokoscKomunikatu*5/3;
    int wysokosc = rozmiarCzcionki*3;
    setPreferredSize(new Dimension(szerokosc, wysokosc));
  }

  /** Rysuje czarny napis a za nim jego wysoki, przechylony "cien".
   */

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2d = (Graphics2D)g;
    int x = szerokoscKomunikatu/10;
    int y = rozmiarCzcionki*5/2;
    g2d.translate(x, y);
    g2d.setPaint(Color.lightGray);
    AffineTransform orgTransformacja = g2d.getTransform();
    g2d.shear(-0.95, 0);
    g2d.scale(1, 3);
    g2d.drawString(komunikat, 0, 0);
    g2d.setTransform(orgTransformacja);
    g2d.setPaint(Color.black);
    g2d.drawString(komunikat, 0, 0);
  }
}