import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.print.*;

/** Przykad okna, ktre mona wydrukowa, dedykowany dla Java 1.2. 
 *  Generalnie w Java 1.2 wydrukowa mona <B>dowolny</B> komponent.
 *  Trzeba jednak pamita aby wyczy funkcj podwjnego buforowania
 *  globalnie (a nie tylko dla okna najwyszego poziomu).
 *  Klasa NarzedziaWydruku zawiera metod  drukujKomponent
 *  umoliwiajc wydrukowanie dowolnego komponentu 
 *  przez wywoanie tylko jednej funkcji.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class PrzykladDrukowania extends JFrame
                           implements ActionListener {
  public static void main(String[] args) {
    new PrzykladDrukowania();
  }

  public PrzykladDrukowania() {
    super("Drukowanie komponentw Swing w JDK 1.2");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();
    JButton przyciskDrukuj = new JButton("Drukuj");
    przyciskDrukuj.addActionListener(this);
    JPanel panelPrzycisku = new JPanel();
    panelPrzycisku.setBackground(Color.white);
    panelPrzycisku.add(przyciskDrukuj);
    zawartosc.add(panelPrzycisku, BorderLayout.SOUTH);
    RysowanyPanel panelRysunku = new RysowanyPanel();
    zawartosc.add(panelRysunku, BorderLayout.CENTER);
    pack();
    setVisible(true);
  }

  public void actionPerformed(ActionEvent event) {
    NarzedziaWydruku.drukujKomponent(this);
  }
}