import java.awt.*;
import javax.swing.*;
import java.awt.print.*;

/** Prosta klasa pomocnicza umoliwiajca wydrukowaniew prosty sposb
 *  dowolnego komponentu w JDK 1.3. Klasa opiera si na fakcie,
 *  e w JDK 1.3 klasa JComponent nadpisuje metod print 
 *  (klasy Container) aby automatycznie ustawiaa flag 
 *  powodujc zablokowanie podwjnego buforowania przed wyrysowaniem 
 *  komponentu. Jeeli flaga ta jest ustawiona to paint wywouje 
 *  kolejno metody printComponent, printBorder, and printChildren.
 *
 *  Aby wydrukowa komponent wystarczy przekaza go do metody
 *  NarzedziaWydruku2.drukujKomponent(drukowanyKomponent). 
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class NarzedziaWydruku2 extends NarzedziaWydruku {

  public static void printComponent(Component c) {
    new NarzedziaWydruku2(c).print();
  }
  
  public NarzedziaWydruku2(Component drukowanyKomponent) {
    super(drukowanyKomponent);
  }
  
  // Oglna metoda drukujca dla JDK 1.3. Drukujc w JDK 1.2 
  // uyj klas NarzedziaWydruku.
  public int print(Graphics g, PageFormat formatStrony, 
                   int numerStrony) {
    if (numerStrony > 0) {
      return(NO_SUCH_PAGE);
    } else {
      Graphics2D g2d = (Graphics2D)g;
      g2d.translate(formatStrony.getImageableX(), 
                    formatStrony.getImageableY());
      drukowanyKomponent.print(g2d);
      return(PAGE_EXISTS);
    }
  }
}