import java.awt.*;
import javax.swing.*;
import java.awt.print.*;

/** Prosta klasa pomocnicza umoliwiajca wydrukowaniew prosty sposb 
 *  dowolnego komponentu w JDK 1.2. Wystarczy tylko przekaza
 *  komponent do metody NarzedziaWydruku.drukujKomponent.  
 *  Drukowany komponent nie  musi posiada metody print 
 *  ani nie musi implementowa adnego interfejsu lub spenia
 *  jaki specjalnych wymaga.
 *  <P>
 *  Jeli drukowanie ma by wykonywane wielokrotnie to odrobin 
 *  bardziej wydajne jest najpierw postpi nastpujco:
 *  <PRE>
 *    NarzedziaWydruku pomocnikWydruku = 
 *      new NarzedziaWydruku(komponent);
 *  </PRE>
 *  i pniej wykona instrukcj pomocnikWydruku.print(). Ale jest to 
 *  bardzo maa rnica, wic w wikszoci sytuacji wystarczy instrukcja
 *  NarzedziaWydruku.drukujKomponent(drukowanyKomponent).
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class NarzedziaWydruku implements Printable {
  protected Component drukowanyKomponent;

  public static void drukujKomponent(Component c) {
    new NarzedziaWydruku(c).print();
  }
  
  public NarzedziaWydruku(Component drukowanyKomponent) {
    this.drukowanyKomponent = drukowanyKomponent;
  }
  
  public void print() {
    PrinterJob zadanieWydruku = PrinterJob.getPrinterJob();
    zadanieWydruku.setPrintable(this);
    if (zadanieWydruku.printDialog())
      try {
        zadanieWydruku.print();
      } catch(PrinterException pe) {
        System.out.println("Bd wydruku: " + pe);
      }
  }

  // Oglna metoda drukujca komponenty dla JDK 1.2. Do drukowania w JDK 1.3 
  // uyj klas NarzedziaWydruku2.
  public int print(Graphics g, PageFormat formatStrony, 
                   int numerStrony) {
    if (numerStrony > 0) {
      return(NO_SUCH_PAGE);
    } else {
      Graphics2D g2d = (Graphics2D)g;
      g2d.translate(formatStrony.getImageableX(), 
                    formatStrony.getImageableY());
      zablokujPodwojneBuforowanie(drukowanyKomponent);
      drukowanyKomponent.paint(g2d);
      odblokujPodwojneBuforowanie(drukowanyKomponent);
      return(PAGE_EXISTS);
    }
  }

  /** Szybko i jako wydruku spada dramatycznie jeeli ktrykolwiek
   *  z podkomponentw ma wczon funkcj podwjnego buforowania,
   *  dlatego ta funkcja blokuje j globalnie. Ten krok jest konieczny 
   *  jedynie w JDK 1.2.
   */
   
  public static void zablokujPodwojneBuforowanie(Component c) {
    RepaintManager biezacyZarzadca = 
                      RepaintManager.currentManager(c);
    biezacyZarzadca.setDoubleBufferingEnabled(false);
  }

  /** Globalnie odblokowuje funkcje podwjnego buforowania. 
   *  Ten krok jest konieczny jedynie w JDK 1.2.
   */
  
  public static void odblokujPodwojneBuforowanie(Component c) {
    RepaintManager biezacyZarzadca = 
                      RepaintManager.currentManager(c);
    biezacyZarzadca.setDoubleBufferingEnabled(true);
  }
}