import javax.swing.*;
import java.awt.*;
import java.util.*;

/** Prosty niestandardowy wywietlacz komrek. Pomys polega na tym,
 *  aby rozszerzy domylny wywietlacz zamiast tworzy nowy od podstaw.
 *  Zalet takiego podejcia jest, e nie musimy samodzielnie 
 *  zajmowa si obsug podwietlania wybranych elementw. 
 *  oraz wartoci innego typu ni nowy typ, ktry chcemy specjalnie 
 *  wywietla mog by obsugiwane automatycznie. Wad jest to,
 *  e takie rozwizanie ogranicza nas jedynie do wariantw etykiety 
 *  JLabel, gdy tak kontrolk zwraca domylny wywietlacz. 
 *  <P>
 *  Metoda jest wywoywana wielokrotnie przy kadym klikniciu 
 *  na pozycji listy. Nie chcemy za kadym razem generowa
 *  nowych obiektw ImageIcon, dlatego tworzymy tablic haszujc,
 *  ktra odwzorowuje poprzednio wywietlane wartoci z ikonami
 *  i umoliwia ponowne uycie ikon dla pozycji, ktre byy 
 *  ju wywietlane. 
 *  <P>
 *  Trzeba wiedzie, e w pierwszej wersji JDK 1.2 domylny wywietlacz 
 *  dziaa nieprawidowo: wywietlacz nie czyci ikon dla kolejnych pozycji. 
 *  W zwizku z tym jeli na licie maj by wywietlane zarwno zwyke napisy 
 *  jak i pozycje posiadajce ikony, to wszystkie napisy bd miay ikony. 
 *  Dlatego w metodzie umieszczona zostaa instrukcja, ktra usuwa 
 *  poprzedni ikon jeli warto nie jest obiektem typu MiejscowoscJava.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class WyswietlaczMiejscowosciJava extends 
                                  DefaultListCellRenderer {
  private Hashtable tablicaIkon = new Hashtable();
  
  public Component getListCellRendererComponent(JList lista,
                                                Object wartosc,
                                                int indeks,
                                                boolean jestWybrany,
                                                boolean jestAktywny) {
    // Najpierw utworz etykiete zawierajaca tekst, 
    // a nastpnie dodaj obrazek.
    JLabel etykieta =
      (JLabel)super.getListCellRendererComponent(lista,
                                                 wartosc,
                                                 indeks,
                                                 jestWybrany,
                                                 jestAktywny);
    if (wartosc instanceof MiejscowoscJava) {
      MiejscowoscJava miejscowos = (MiejscowoscJava)wartosc;
      ImageIcon ikona = (ImageIcon)tablicaIkon.get(wartosc);
      if (ikona == null) {
        ikona = new ImageIcon(miejscowos.podajPlikFlagi());
        tablicaIkon.put(wartosc, ikona);
      }
      etykieta.setIcon(ikona);
    } else {
      // Wyczy star ikon -- wymagane w pierwszej wersji JDK 1.2.
      etykieta.setIcon(null); 
    }
    return(etykieta);
  }
}