import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

/** Przykad prostego uycia kontrolki JList ilustrujcy
 *  <UL>
 *    <LI>Tworzenie kontrolki JList przez przekazanie wartoci 
 *        bezporednio do konstruktora JList, a nie przez
 *        wykorzystanie struktury ListModel, oraz
 *    <LI>Doczanie odbiornika umoliwiajcego okrelenie kiedy 
 *        zmienia si warto.
 *  </UL>
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class PrzykladProstejListy extends JFrame {
  public static void main(String[] args) {
    new PrzykladProstejListy();
  }

  private JList przykladowaLista;
  private JTextField poleWartosci;
  
  public PrzykladProstejListy() {
    super("Tworzenie prostej kontrolki JList");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container zawartosc = getContentPane();

    // Create the JList, set the number of visible rows, add a
    // listener, and put it in a JScrollPane.
    String[] pozycje = { "Pozycja 1", "Pozycja 2", "Pozycja 3",
                         "Pozycja 4", "Pozycja 5", "Pozycja 6" };
    przykladowaLista = new JList(pozycje);
    przykladowaLista.setVisibleRowCount(4);
    przykladowaLista.addListSelectionListener(new PowiadamiaczWartosci());
    JScrollPane poleListy = new JScrollPane(przykladowaLista);
    Font czcionka = new Font("Serif", Font.BOLD, 18);
    przykladowaLista.setFont(czcionka);

    JPanel panelListy = new JPanel();
    panelListy.setBackground(Color.white);
    Border ramkaPaneluListy =
      BorderFactory.createTitledBorder("Przykadowa kontrolka JList");
    panelListy.setBorder(ramkaPaneluListy);
    panelListy.add(poleListy);
    zawartosc.add(panelListy, BorderLayout.CENTER);
    JLabel etykietaWartosci = new JLabel("Ostatnio wybrana:");
    etykietaWartosci.setFont(czcionka);
    poleWartosci = new JTextField("adna", 7);
    poleWartosci.setFont(czcionka);
    poleWartosci.setEditable(false);
    JPanel panelWartosci = new JPanel();
    panelWartosci.setBackground(Color.white);
    Border ramkaPaneluWartosci =
      BorderFactory.createTitledBorder("Wybr na JList");
    panelWartosci.setBorder(ramkaPaneluWartosci);
    panelWartosci.add(etykietaWartosci);
    panelWartosci.add(poleWartosci);
    zawartosc.add(panelWartosci, BorderLayout.SOUTH);
    pack();
    setVisible(true);
  }

  private class PowiadamiaczWartosci implements ListSelectionListener {

    /** W wikszoci przypadkw otrzymujemy trzy zdarzenia: 
     *  jedno oznaczajce odznaczenie poprzednio wybranej pozycji,
	 *  drugie oznaczajce e zaznaczenie jest przemieszczene, 
     *  oraz trzecie oznaczajce wybranie nowej pozycji. 
	 *  W pierwszych dwu przypadkach getValueIsAdjusting zwraca
	 *  warto true, zatem poniszy test wybiera tylko
	 *  trzeci przypadek.
     */

    public void valueChanged(ListSelectionEvent zdarzenie) {
      if (!zdarzenie.getValueIsAdjusting()) {
        Object wartosc = przykladowaLista.getSelectedValue();
        if (wartosc != null) {
          poleWartosci.setText(wartosc.toString());
        }  
      }
    }
  }
}