import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

/** Przykad uycia kontrolki JList ilustrujcy
 *  <UL>
 *    <LI>Tworzenie kontrolki JList przez utworzenie obiektu DefaultListModel,
 *        dodanie do niego pozycji listy, a nastpnie przekazanie modelu
 *        jako argument konstruktora klasy JList.
 *    <LI>Dodawanie nowych wartoci podczas wykonywania programu, co jest podstawow
 *        funkcj jak udostpnia model DefaultListModel, a czego nie mona zrobi
 *        jeli wartoci zostan przekazane bezporednio do kontrolki JList.
 *  </UL>
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class PrzykladDomyslnegoModeluListy extends JFrame {
  public static void main(String[] args) {
    new PrzykladDomyslnegoModeluListy();
  }

  JList przykladowaLista;
  private DefaultListModel przykladowyModel;
  
  public PrzykladDomyslnegoModeluListy() {
    super("Tworzenie prostej kontrolki JList");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container content = getContentPane();
   
    String[] pozycje = { "Pozycja 1", "Pozycja 2", "Pozycja 3",
                         "Pozycja 4", "Pozycja 5", "Pozycja 6" };
    przykladowyModel = new DefaultListModel();
    for(int i=0; i<pozycje.length; i++) {
      przykladowyModel.addElement(pozycje[i]);
    }
    przykladowaLista = new JList(przykladowyModel);
    przykladowaLista.setVisibleRowCount(4);
    Font czcionka = new Font("Serif", Font.BOLD, 18);
    przykladowaLista.setFont(czcionka);
    JScrollPane poleListy = new JScrollPane(przykladowaLista);
    
    JPanel panelListy = new JPanel();
    panelListy.setBackground(Color.white);
    Border ramkaPaneluListy =
      BorderFactory.createTitledBorder("Przykadowa kontrolka JList");
    panelListy.setBorder(ramkaPaneluListy);
    panelListy.add(poleListy);
    content.add(panelListy, BorderLayout.CENTER);
    JButton przyciskDodaj =
      new JButton("Dodaj wpis na kocu listy");
    przyciskDodaj.setFont(czcionka);
    przyciskDodaj.addActionListener(new DodawaczWpisow());
    JPanel panelPrzycisku = new JPanel();
    panelPrzycisku.setBackground(Color.white);
    Border ramkaPaneluPrzycisku =
      BorderFactory.createTitledBorder("Dodawanie wpisw");
    panelPrzycisku.setBorder(ramkaPaneluPrzycisku);
    panelPrzycisku.add(przyciskDodaj);
    content.add(panelPrzycisku, BorderLayout.SOUTH);
    pack();
    setVisible(true);
  }

  private class DodawaczWpisow implements ActionListener {
    
    /** Za kadym razem kiedy uytkownik nacinie przycisk
     *  dodaj nowy wpis do listy. Poniewa nowe wpisy mog by
     *  szersze ni wczeniejsze pozycje (np. "Pozycja 10" 
     *  wzgldem "Pozycja 9") konieczne jest ponowne uruchomienie 
	 *  zarzdcy rozkadu. Operacja ta musi zosta wykonana <I>przed</I>
     *  prb przewinicia listy aby indeks by widoczny.
     */

    public void actionPerformed(ActionEvent event) {
      int indeks = przykladowyModel.getSize();
      przykladowyModel.addElement("Pozycja " + (indeks+1));
      ((JComponent)getContentPane()).revalidate();
      przykladowaLista.setSelectedIndex(indeks);
      przykladowaLista.ensureIndexIsVisible(indeks);
    }
  }
}