/** Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */


// Ostateczna wersja klasy TransferPliku. Modyfikowanie stanu etykiet
// jest bezpieczne dla wykonania wielowtkowego.

public class TransferPliku extends Thread {
  private String nazwapliku;
  private JLabel etykieta;

  public TransferPliku(String nazwapliku, JLabel etykieta) {
    this.nazwapliku = nazwapliku;
    this.etykieta = etykieta;
  }

  public void run() {

    try {
      // Umie w kolejce zdarze obiekt typu Runnable uaktualniajcy 
      // etykiet. Metoda invokeAndWait zablokuje wtek do czasu,
      // a etykieta zostanie uaktualniona. 
      SwingUtilities.invokeAndWait(
        new Runnable() {
          public void run() {
            etykieta.setText("Przesyam " + nazwapliku);
          }
        });
    } catch(InvocationTargetException ite) {
    } catch(InterruptedException ie) { }
    
    // Przelij plik na serwer. Dugotrwajca operacja.
    wykonajTransfer(...);

    // Wykonaj kocowe uaktualnienie etykiet z poziomu obiektu typu 
    // Runnable. Korzystamy z metody invokeLater bo w tym przypadku 
    // blokowanie nie jest konieczne.
    SwingUtilities.invokeLater(
      new Runnable() {
        public void run() {
          etykieta.setText("Przesyanie zakoczone.");
        }
      });
  }
}