import java.awt.*;
import javax.swing.*;

/** Kod ten stanowi fragment przykadu prezentujcego zasady posugiwania si obiektem JToolBar.
 *  Niniejszy program ilustruje problem dodawania przycisku JButton do paska narzdziowego,
 *  co w JDK 1.2 nie daje podanych efektw (tzn. nie mona uzyska maego przycisku
 *  z tekstem umieszczonym poniej ikony). Z kolei dodanie do paska narzdziowego
 *  komponentu Action w JDK 1.3 powoduje, e jego etykieta nie zostanie wywietlona.
 */

public class PrzyciskPaskaNarzedziowego extends JButton {
  private static final Insets marginesy =
    new Insets(0, 0, 0, 0);

  public PrzyciskPaskaNarzedziowego(Icon ikona) {
    super(ikona);
    setMargin(marginesy);
    setVerticalTextPosition(BOTTOM);
    setHorizontalTextPosition(CENTER);
  }

  public PrzyciskPaskaNarzedziowego(String plikRysunku) {
    this(new ImageIcon(plikRysunku));
  }

  public PrzyciskPaskaNarzedziowego(String plikRysunku, String tekst) {
    this(new ImageIcon(plikRysunku));
    setText(tekst);
  }
}
