import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/** Bardzo prosta przegldarka internetowa. 
 *  Doczenie w linii polecenia adresu URL powoduje otwarcie strony
 *  o podanym adresie i zapamitanie go jako adresu strony "domowej"
*/

public class Przegladarka extends JFrame implements HyperlinkListener, 
                                               ActionListener {
  public static void main(String[] argumenty) {
    if (argumenty.length == 0)
      new Przegladarka("http://www.helion.pl/");
    else
      new Przegladarka(argumenty[0]);
  }

  private PrzyciskZIkona strDomowa;
  private JTextField poleUrl;
  private JEditorPane panelHtml;
  private String poczatkowyUrl;

  public Przegladarka(String poczatkowyUrl) {
    super("Prosta przegldarka internetowa");
    this.poczatkowyUrl = poczatkowyUrl;
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());

    JPanel gornyPanel = new JPanel();
    gornyPanel.setBackground(Color.lightGray);
    strDomowa = new PrzyciskZIkona("home.gif");
    strDomowa.addActionListener(this);
    JLabel etykietaUrl = new JLabel("URL:");
    poleUrl = new JTextField(30);
    poleUrl.setText(poczatkowyUrl);
    poleUrl.addActionListener(this);
    gornyPanel.add(strDomowa);
    gornyPanel.add(etykietaUrl);
    gornyPanel.add(poleUrl);
    getContentPane().add(gornyPanel, BorderLayout.NORTH);

    try {
        panelHtml = new JEditorPane(poczatkowyUrl);
        panelHtml.setEditable(false);
        panelHtml.addHyperlinkListener(this);
        JScrollPane panelPrzewijany = new JScrollPane(panelHtml);
        getContentPane().add(panelPrzewijany, BorderLayout.CENTER);
    } catch(IOException ioe) {
       ostrzezenie("Nie mona otworzy dokumenti HTML " + poczatkowyUrl 
                + ": " + ioe);
    }

    Dimension rozmiarEkranu = getToolkit().getScreenSize();
    int szerokosc = rozmiarEkranu.width * 8 / 10;
    int wysokosc = rozmiarEkranu.height * 8 / 10;
    setBounds(szerokosc/8, wysokosc/8, szerokosc, wysokosc);
    setVisible(true);
  }

  public void actionPerformed(ActionEvent zdarzenie) {
    String url;
    if (zdarzenie.getSource() == poleUrl) {
      url = poleUrl.getText();
    } else { // Zamiast podania adresu kliknito przycisk strony domowej
      url = poczatkowyUrl;
    }
    try {
      panelHtml.setPage(new URL(url));
      poleUrl.setText(url);
    } catch(IOException ioe) {
      ostrzezenie("Nie mona przej do strony " + url + ": " + ioe);
    }
  }

  public void hyperlinkUpdate(HyperlinkEvent zdarzenie) {
    if (zdarzenie.getEventType() == 
        HyperlinkEvent.EventType.ACTIVATED) {
      try {
        panelHtml.setPage(zdarzenie.getURL());
        poleUrl.setText(zdarzenie.getURL().toExternalForm());
      } catch(IOException ioe) {
        ostrzezenie("Nie mona przej do strony " 
                + zdarzenie.getURL().toExternalForm() + ": " + ioe);
      }
    }
  }

  private void ostrzezenie(String komunikat) {
    JOptionPane.showMessageDialog(this, komunikat, "Bd", 
                                  JOptionPane.ERROR_MESSAGE);
  }
}
