import java.awt.*;
import javax.swing.*;

/** Kod ten stanowi fragment programu demonstrujcego uycie obiektu JToolBar.
 *  Powouje dokowalny pasek narzdziowy, ktrego wygld przypomina
 *  paski narzdziowe popularnych przegldarek internetowych.
 *  W programie wykorzystano klas PrzyciskPaskaNarzedziowego, ktra
 *  redukuje marginesy wok ikony i umieszcza opis przycisku pod rysunkiem.
*/
 
public class PasekNarzedziowyPrzegladarki extends JToolBar {
  public PasekNarzedziowyPrzegladarki() { 
    String[] plikiRysunkow =
      { "Left.gif", "Right.gif", "RotCCUp.gif",
        "TrafficRed.gif", "Home.gif", "Print.gif", "Help.gif" };
    String[] etykiety =
      { "Wstecz", "Dalej", "Odwie", "Zatrzymaj", 
        "Start", "Drukuj", "Pomoc" };
    Insets marginesy = new Insets(0, 0, 0, 0);
    for(int i=0; i<etykiety.length; i++) {
      PrzyciskPaskaNarzedziowego przycisk =
        new PrzyciskPaskaNarzedziowego("rysunki/" + plikiRysunkow[i]);
      przycisk.setToolTipText(etykiety[i]);
      przycisk.setMargin(marginesy);
      add(przycisk);
    }
  }

  public void ustawEtykiety(boolean etykietyWlaczone) {
    Component c;
    int i = 0;
    while((c = getComponentAtIndex(i++)) != null) {
      PrzyciskPaskaNarzedziowego przycisk = (PrzyciskPaskaNarzedziowego)c;
      if (etykietyWlaczone) {
        przycisk.setText(przycisk.getToolTipText());
      } else {
        przycisk.setText(null);
      }
    }
  }
}
