import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/** Przykad zastosowania obiektu JToolBar.  */

public class JToolBarTest extends JFrame
                             implements ItemListener {
  private PasekNarzedziowyPrzegladarki pasek;
  private JCheckBox poleEtykiet;

  public static void main(String[] argumenty) {
    new JToolBarTest();
  }

  public JToolBarTest() {
    super("Przykad wykorzystania obiektu JToolBar");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container panelZaw = getContentPane();
    panelZaw.setBackground(Color.white);
    
    JPanel panel = new JPanel(new BorderLayout());
    poleEtykiet = new JCheckBox("Wywietla etykiety przyciskw?");
    poleEtykiet.setHorizontalAlignment(SwingConstants.CENTER);
    poleEtykiet.addItemListener(this);
    panel.add(new JTextArea(10,30), BorderLayout.CENTER);
    panel.add(poleEtykiet, BorderLayout.SOUTH);

    pasek = new PasekNarzedziowyPrzegladarki();
    panelZaw.add(pasek, BorderLayout.NORTH);
    panelZaw.add(panel, BorderLayout.CENTER);

    pack();
    setVisible(true);
  }

  public void itemStateChanged(ItemEvent zdarzenie) {
    pasek.ustawEtykiety(poleEtykiet.isSelected());
    pack();
  }
}
