import java.awt.*;
import javax.swing.*;

/** Przykad ilustrujcy zasady korzystania z komponentw JSliders, a szczeglnie
 *  z moliwoci definiowania znacznikw przesunicia i ich opisw.
 */

public class JSliderTest extends JFrame {
  public static void main(String[] argumenty) {
    new JSliderTest();
  }

  public JSliderTest() {
    super("Wykorzystanie obiektw JSlider");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container panel = getContentPane();
    panel.setBackground(Color.white);
    
    JSlider suwak1 = new JSlider();
    suwak1.setBorder(BorderFactory.createTitledBorder
                        ("Bez znacznikw przesunicia"));
    panel.add(suwak1, BorderLayout.NORTH);
    
    JSlider suwak2 = new JSlider();
    suwak2.setBorder(BorderFactory.createTitledBorder
                        ("Ze znacznikami przesunicia"));
    suwak2.setMajorTickSpacing(20);
    suwak2.setMinorTickSpacing(5);
    suwak2.setPaintTicks(true);
    panel.add(suwak2, BorderLayout.CENTER);

    JSlider suwak3 = new JSlider();
    suwak3.setBorder(BorderFactory.createTitledBorder
                        ("Ze znacznikami i opisami"));
    suwak3.setMajorTickSpacing(20);
    suwak3.setMinorTickSpacing(5);
    suwak3.setPaintTicks(true);
    suwak3.setPaintLabels(true);
    panel.add(suwak3, BorderLayout.SOUTH);
    
    pack();
    setVisible(true);
  }
}
