import java.awt.*;
import javax.swing.*;

/** Przykad ilustrujcy zasady korzystania z komponentw JPanel, a szczeglnie
 *  z moliwoci definiowania obramowania.
 */


public class JPanelTest extends JFrame {
  public static void main(String[] argumenty) {
    new JPanelTest();
  }

  public JPanelTest() {
    super("Wykorzystanie obiektw JPanels i ich obramowa");
    NarzedziaOkienkowe.ustawWygladSystemowy();
    addWindowListener(new NasluchWyjscia());
    Container panel = getContentPane();
    panel.setBackground(Color.lightGray);
    JPanel obszarKontrolek = new JPanel(new GridLayout(3, 1));
    String[] kolory = { "Czerwony", "Zielony", "Niebieski",
                        "Czarny", "Biay", "Szary" };
    obszarKontrolek.add(new PanelSzesciuOpcji("Kolor", kolory));
    String[] grubosci = { "1", "2", "3", "4", "5", "6" };
    obszarKontrolek.add(new PanelSzesciuOpcji("Grubo linii",
                                       grubosci));
    String[] rozmiaryCzcionki = { "10", "12", "14", "18", "24", "36" };
    obszarKontrolek.add(new PanelSzesciuOpcji("Rozmiar czcionki",
                                       rozmiaryCzcionki));
    panel.add(obszarKontrolek, BorderLayout.EAST);
    JPanel obszarRysowania = new JPanel();
    // Preferowany rozmiar jest nieistotny ze wzgldu na umieszczenie obiektu w obszarze WEST.
    obszarRysowania.setPreferredSize(new Dimension(400, 0));
    obszarRysowania.setBorder
               (BorderFactory.createLineBorder (Color.blue, 2));
    obszarRysowania.setBackground(Color.white);
    panel.add(obszarRysowania, BorderLayout.WEST);
    pack();
    setVisible(true);
  }
}
