import java.awt.*;
import java.awt.event.*;

/** Klasa demonstrujca zaznaczanie i usuwanie zaznaczenie elementu listy
 *  oraz zdarzenia ActionEvents.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class ZdarzeniaListy extends ZamykalnaRamka {
  public static void main(String[] argumenty) {
    new ZdarzeniaListy();
  }

  protected List listaJezykow;
  private TextField poleZaznaczenia, poleWyboru;
  private String zaznaczenie = "[BRAK]", wybor;

  /** Utorzenie ramki z list jzykw programowania,
   *  i dwoma polami tekstowymi, przedstawiajcymi
   *  ostatnio wskazan pozycj i ostatnio wybran pozycj listy
   */
  public ZdarzeniaListy() {
    super("ZdarzeniaListy");
    setFont(new Font("Serif", Font.BOLD, 16));
    add(utworzPanelJezykow(), BorderLayout.WEST);
    add(utworzPanelInformacyjny(), BorderLayout.CENTER);
    pack();
    setVisible(true);
  }

  // Utworzenie komponentu Panel zawierajcego list jzykw.
  // Konstruktor umieszcza j w lewej czci ramki.
  
  private Panel utworzPanelJezykow() {
    Panel panelJezykow = new Panel();
    panelJezykow.setLayout(new BorderLayout());
    panelJezykow.add(new Label("Wybierz jzyk"), 
                      BorderLayout.NORTH);
    listaJezykow = new List(3);
    String[] jezyki =
      { "Ada", "C", "C++", "Common Lisp", "Eiffel",
        "Forth", "Fortran", "Java", "Pascal",
        "Perl", "Scheme", "Smalltalk" };
    for(int i=0; i<jezyki.length; i++) {
      listaJezykow.add(jezyki[i]);
    }
    pokazJave();
    panelJezykow.add("Center", listaJezykow);
    return(panelJezykow);
  }

  // Utworzenie paneli z dwoma etykietami i dwoma polami tekstowymi.
  // Pierwsze z pl informuje o ostatnio wskazanej pozycji.
  // Drugie pole przedstawia ostatnio wybran pozycj. Konstruktor
  // umieszcza panel w prawej czi ramki.

  private Panel utworzPanelInformacyjny() {
    Panel panelInfo = new Panel();
    panelInfo.setLayout(new GridLayout(4, 1));
    panelInfo.add(new Label("Ostatnie zaznaczenie:"));
    poleZaznaczenia = new TextField();
    ZaznaczenieInfo zaznaczenieInfo =
      new ZaznaczenieInfo(poleZaznaczenia);
    listaJezykow.addItemListener(zaznaczenieInfo);
    panelInfo.add(poleZaznaczenia);
    panelInfo.add(new Label("Ostatni wybr:"));
    poleWyboru = new TextField();
    WyborInfo wyborInfo = 
      new WyborInfo(poleWyboru);
    listaJezykow.addActionListener(wyborInfo);
    panelInfo.add(poleWyboru);
    return(panelInfo);
  }

  /** Wybranie i wywietlenie tekstu "Java". */
  
  protected void pokazJave() {
    listaJezykow.select(7);
    listaJezykow.makeVisible(7);
  }
}