import java.awt.*;
import java.awt.event.*;
import java.io.*;

/** Przykad ramki umoliwiajcej rysowanie k 
 *  oraz zapisywanie stanu caego okna na dysku.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */


public class ZapisywanaRamka extends ZamykalnaRamka
                        implements ActionListener {
  
  /** Pobranie zapisanej wczeniej ramki lub utworzenie nowej.
   */
                          
  public static void main(String[] argumenty) {
    ZapisywanaRamka ramka;
    File plik = new File(nazwaPliku);
    if (plik.exists()) {
      try {
        FileInputStream plikWej = 
          new FileInputStream(plik);
        ObjectInputStream wej = new ObjectInputStream(plikWej);
        ramka = (ZapisywanaRamka)wej.readObject();
        ramka.setVisible(true);
      } catch(IOException ioe) {
        System.out.println("Bd odczytu pliku: " + ioe);
      } catch(ClassNotFoundException cnfe) {
        System.out.println("Podana klasa nie istnieje: " + cnfe);
      }
    } else {
      ramka = new ZapisywanaRamka();
    }
  }

  private static String nazwaPliku ="Ramka.dat";
  private PanelKol panelKol;
  private Button przyciskCzyszczenia, przyciskZapisu;

  /** Utwrozenie ramki zawierajcej obiekt PanelKol i kontrolki przyciskw. */
                          
  public ZapisywanaRamka() {
    super("ZapisanaRamka");
    setBackground(Color.white);
    setFont(new Font("Serif", Font.BOLD, 18));
    panelKol = new PanelKol();
    add("Center", panelKol);
    Panel panelPrzyciskow = new Panel();
    panelPrzyciskow.setBackground(Color.lightGray);
    przyciskCzyszczenia = new Button("Wyczy");
    przyciskZapisu = new Button("Zapisz");
    panelPrzyciskow.add(przyciskCzyszczenia);
    panelPrzyciskow.add(przyciskZapisu);
    add(panelPrzyciskow, BorderLayout.SOUTH);
    przyciskCzyszczenia.addActionListener(this);
    przyciskZapisu.addActionListener(this);
    setSize(300, 300);
    setVisible(true);
  }

  /** Jeeli zosta nacinity przycisk "Wyczy" naley usun istniejce obiekty k.
   *  Jeeli nacinito przycisk "Zapisz" naley zapisa aktualny wygld ramki 
   *  (rozmiar, pooenie, informacje o umieszczonych koach).
   */
                          
  public void actionPerformed(ActionEvent zdarzenie) {
    if (zdarzenie.getSource() == przyciskCzyszczenia) {
      panelKol.removeAll();
      panelKol.repaint();
    } else if (zdarzenie.getSource() == przyciskZapisu) {
      try {
        FileOutputStream plikWyj =
          new FileOutputStream("Ramka.dat");
        ObjectOutputStream wyj = 
          new ObjectOutputStream(plikWyj);
        wyj.writeObject(this);
        wyj.flush();
        wyj.close();
      } catch(IOException ioe) {
        System.out.println("Bd zapisu ramki: " + ioe);
      }
    }
  }
}