import java.awt.*;
import java.awt.event.*;
import java.io.*;

/** Wykorzystane w programie okno FileDialog pozwala uytkownikowi na
 *  wskazanie pliku, ktry ma by wywietlony w plu tekstowym. 
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class WyswietleniePliku extends ZamykalnaRamka 
                         implements ActionListener {
                                
  public static void main(String[] argumenty) {
    new WyswietleniePliku();
  }

  private Button przyciskPobierz;
  private TextArea zawartoscPliku;
  private FileDialog oknoPliku;

  public WyswietleniePliku() {
    super("Zastosowanie okna FileDialog");
    przyciskPobierz = new Button("Pobierz plik");
    przyciskPobierz.addActionListener(this);
    Panel panelPrzyciskow = new Panel();
    panelPrzyciskow.add(przyciskPobierz);
    add(panelPrzyciskow, BorderLayout.SOUTH);
    zawartoscPliku = new TextArea();
    add("Center", zawartoscPliku);
    oknoPliku = new FileDialog(this, "Przegldaj", FileDialog.LOAD);
    // Domylne rozszerzenie pliku - .java.
    oknoPliku.setFile("*.java");
    setSize(350, 450);
    setVisible(true);
  }

  /** Otwarcie okna dialogowego nastpuje po klikniciu przycisku "Przegldaj". 
   *  Wskazany plik jest pobierany po zamkniciu okna.
   */
  
  public void actionPerformed(ActionEvent zdarzenie) {
      oknoPliku.show();
      wyswietlPlik(oknoPliku.getFile());
  }

  public void wyswietlPlik(String nazwaPliku) {
    try {
      File plik = new File(nazwaPliku);
      FileInputStream wej = new FileInputStream(plik);
      int dlugoscPliku = (int)plik.length();
      byte[] dane = new byte[dlugoscPliku];
      wej.read(dane);
      String ciagTekstowyDanych = new String(dane);
      zawartoscPliku.setText(ciagTekstowyDanych);
    } catch(IOException ioe) {
      zawartoscPliku.setText("Bd IO: " + ioe);
    }
  }
}