import java.awt.*;
import java.awt.event.*;

/** Udoskonalone obiekty paskw przewijania. Niniejsza klasa 
 *  eliminuje problem ignorowania polece zwikszania 
 *  wartoci. Ilustruje jednoczenie zasad posugiwania si 
 *  niskopoziomowymi zdarzeniami obiektu Scrollbar.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class UdoskonalonyPasekPrzewijania extends Scrollbar {
  private int ostatniaWartosc;

  public UdoskonalonyPasekPrzewijania(int kierunek,
                                       int wartoscPoczatkowa,
                                       int rozmiarSuwaka,
                                       int minimum,
                                       int maksimum) {
    super(kierunek, wartoscPoczatkowa, rozmiarSuwaka, minimum, maksimum);
    enableEvents(AWTEvent.ADJUSTMENT_EVENT_MASK);
    ostatniaWartosc = wartoscPoczatkowa;
  }

  /** Monitorowanie zdarze i zwikszanie wartoci w sposb
   *  jednostkowy lub blokowy.
   */
   
  public void processAdjustmentEvent(AdjustmentEvent e) {
    int typ = e.getAdjustmentType();
    switch(typ) {
      case AdjustmentEvent.UNIT_INCREMENT:
        setValue(ostatniaWartosc + getUnitIncrement());
        break;
      case AdjustmentEvent.UNIT_DECREMENT:
        setValue(ostatniaWartosc - getUnitIncrement());
        break;
      case AdjustmentEvent.BLOCK_INCREMENT:
        setValue(ostatniaWartosc + getBlockIncrement());
        break;
      case AdjustmentEvent.BLOCK_DECREMENT:
        setValue(ostatniaWartosc - getBlockIncrement());
        break;
    }
    ostatniaWartosc = getValue();
    super.processAdjustmentEvent(e);
  }
}