import java.awt.*;
import java.awt.event.*;

/** Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class PrzykladZdarzeniaAction2 extends ZamykalnaRamka
                            implements ActionListener {
  public static void main(String[] argumenty) {
    new PrzykladZdarzeniaAction2();
  }

  private Button przycisk1, przycisk2, przycisk3;

  public PrzykladZdarzeniaAction2() {
    super("Obuga zdarze w innym obiekcie");
    setLayout(new FlowLayout());
    setFont(new Font("Serif", Font.BOLD, 18));
    przycisk1 = new Button("Rozmiar 300x200");
    przycisk2 = new Button("Rozmiar 400x300");
    przycisk3 = new Button("Rozmiar 500x400");
    przycisk1.addActionListener(this);
    przycisk2.addActionListener(this);
    przycisk3.addActionListener(this);
    add(przycisk1);
    add(przycisk2);
    add(przycisk3);
    setSize(400, 300);
    setVisible(true);
  }

  public void actionPerformed(ActionEvent zdarzenie) {
    if (zdarzenie.getSource() == przycisk1) {
      uaktualnijWyglad(300, 200);
    } else if (zdarzenie.getSource() == przycisk2) {
      uaktualnijWyglad(400, 300);
    } else if (zdarzenie.getSource() == przycisk3) {
      uaktualnijWyglad(500, 400);
    }
  }
  
  private void uaktualnijWyglad(int szerokosc, int wysokosc) {
    setSize(szerokosc, wysokosc);
    invalidate();
    validate();
  }
}