import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/** Przykad menu kontekstowego.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class MenuKontekstoweKolorow extends Applet
                            implements ActionListener {
 private String[] nazwyKolorow =
   { "Biay", "Jasnoszary", "Szary", "Ciemnoszary", "Czarny" };
  private Color[] kolory =
    { Color.white, Color.lightGray, Color.gray,
      Color.darkGray, Color.black };
  private PopupMenu menu;

  /** Utworzenie obiektw PopupMenu i MenuItems. */
                              
  public void init() {
    setBackground(Color.gray);
    menu = new PopupMenu("Kolor ta");
    enableEvents(AWTEvent.MOUSE_EVENT_MASK);
    MenuItem nazwaKoloru;
    for(int i=0; i<nazwyKolorow.length; i++) {
      nazwaKoloru = new MenuItem(nazwyKolorow[i]);
      menu.add(nazwaKoloru);
      nazwaKoloru.addActionListener(this);
      menu.addSeparator();
    }
    add(menu);
  }

  /** Nie naley korzysta a interfejsu MouseListener, gdy wywoanie
   *  metody isPopupTrigger w systenie Win95/98/NT
   *  musiaoby umieszczone w metodzie mouseReleased, 
   *  a wywoanie tej samej metody w systemie Solaris - w metodzie mousePressed.
   */
  public void processMouseEvent(MouseEvent zdarzenie) {
    if (zdarzenie.isPopupTrigger()) {
      menu.show(zdarzenie.getComponent(), zdarzenie.getX(), 
                zdarzenie.getY());
    }
    super.processMouseEvent(zdarzenie);
  }
  
  public void actionPerformed(ActionEvent zdarzenie) {
    setBackground(wyborKoloru(zdarzenie.getActionCommand()));
    repaint();
  }

  private Color wyborKoloru(String nazwaKoloru) {
    for(int i=0; i<nazwyKolorow.length; i++) {
      if(nazwyKolorow[i].equals(nazwaKoloru)) {
        return(kolory[i]);
      }
    }
    return(Color.white);
  }
}