import java.awt.*;
import java.awt.event.*;

/** Przykad umieszczania elementw menu na
 *  pasku menu obiektu Frame.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class MenuKolorow extends ZamykalnaRamka 
                       implements ActionListener {
                        
  private String[] nazwyKolorow =
    { "Czarny", "Biay", "Jasnoszary", "Szary", 
      "Ciemnoszary" };
  private Color[] wartosciKolorow =
    { Color.black, Color.white, Color.lightGray, 
      Color.gray, Color.darkGray };
   
  public MenuKolorow() {
    super("MenuKolorow");
    MenuBar pasek = new MenuBar();
    Menu menuKolorow = new Menu("Kolory");
    for(int i=0; i<2; i++) {
      menuKolorow.add(nazwyKolorow[i]);
    }
    Menu menuSzarych = new Menu("Szare");
    for(int i=2; i<nazwyKolorow.length; i++) {
      menuSzarych.add(nazwyKolorow[i]);
    }
    menuKolorow.add(menuSzarych);
    pasek.add(menuKolorow);
    setMenuBar(pasek);
    menuKolorow.addActionListener(this);
    menuSzarych.addActionListener(this);
    
    setBackground(Color.lightGray);
    setSize(400, 200);
    setVisible(true);
  }

  /** Przechwytywanie zdarze menu ramki. */
  
  public void actionPerformed(ActionEvent zdarzenie) {
      setBackground(kolor(zdarzenie.getActionCommand()));
      repaint();
  }

  private Color kolor(String nazwaKoloru) {
    for(int i=0; i<nazwyKolorow.length; i++) {
      if(nazwyKolorow[i].equals(nazwaKoloru)) {
        return(wartosciKolorow[i]);
      }
    }
    return(Color.white);
  }  
  
  public static void main(String[] argumenty) {
    new MenuKolorow();
  }
    
}