import java.awt.*;

/** Udoskonalona klasa Kolo zastpujca obiekt Canvas
 *  lekkimi obiektami jzyka Java 1.1
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class LepszeKolo extends Component {
  private Dimension preferowanyRozmiar;
  private int szerokosc, wysokosc;
  
  public LepszeKolo(Color pierwszyPlan, int promien) {
    setForeground(pierwszyPlan);
    szerokosc = 2*promien;
    wysokosc = 2*promien;
    preferowanyRozmiar = new Dimension(szerokosc, wysokosc);
    setSize(preferowanyRozmiar);
  }

  public void paint(Graphics g) {
    g.setColor(getForeground());
    g.fillOval(0, 0, szerokosc, wysokosc);
  }

  public void ustawSrodek(int x, int y) {
    setLocation(x - szerokosc/2, y - wysokosc/2);
  }

  /** Metoda, ktra zawraca pierwotny rozmiar jako rozmiar preferowany.
   *  Dziki temu obiekt LepszeKolo nie podlega skalowaniu
   *  w wyniku dziaania menedera rozmieszczenia.
   */
  
  public Dimension getPreferredSize() {
    return(preferowanyRozmiar);
  }

  /** Metoda, ktra zwraca preferowany rozmiar jako
   *  romzmiar minimalny.
   */
  
  public Dimension getMinimumSize() {
    return(preferowanyRozmiar);
  }
}