import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

/** Przykad wykorzystania menedera rozmieszczenia GridBagLayout w 
 *  graficznym interfejsie uytkownika zawierajcym pole tekstowe i 
 *  trzy przyciski.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class TestGridBagLayout extends JPanel {
  private JTextArea obszarTekstowy;
  private JButton pZapiszJako, pOk, pWyjscie;
  private JTextField polePliku;
  private GridBagConstraints c;

  public TestGridBagLayout() {
    setLayout(new GridBagLayout());
    setBorder(BorderFactory.createEtchedBorder());

    obszarTekstowy = new JTextArea(12,40);  // 12 wierszy, 40 kolumn
    pZapiszJako = new JButton("Zapisz jako");
    polePliku = new JTextField("C:\\Dokument.txt");
    pOk = new JButton("OK");
    pWyjscie = new JButton("Wyjcie");

    c = new GridBagConstraints();

    // Obszar tekstowy
    c.gridx      = 0;
    c.gridy      = 0;
    c.gridwidth  = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    c.weightx    = 1.0;
    c.weighty    = 1.0;
    c.fill       = GridBagConstraints.BOTH;
    c.insets     = new Insets(2,2,2,2); //g,l,d,p
    add(obszarTekstowy,c);

    // Przycisk "Zapisz jako"
    c.gridx      = 0;
    c.gridy      = 1;
    c.gridwidth  = 1;
    c.gridheight = 1;
    c.weightx    = 0.0;
    c.weighty    = 0.0;
    c.fill       = GridBagConstraints.VERTICAL;
    add(pZapiszJako,c);

    // Pole tekstowe nazwy pliku
    c.gridx      = 1;
    c.gridwidth  = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    c.weightx    = 1.0;
    c.weighty    = 0.0;
    c.fill       = GridBagConstraints.BOTH;
    add(polePliku,c);

    // Przycisk "OK"
    c.gridx      = 2;
    c.gridy++;
    c.gridwidth  = 1;
    c.gridheight = 1;
    c.weightx    = 0.0;
    c.weighty    = 0.0;
    c.fill       = GridBagConstraints.NONE;
    add(pOk,c);

    // Przycisk "Wyjscie"
    c.gridx      = 3;
    c.gridwidth  = 1;
    c.gridheight = 1;
    c.weightx    = 0.0;
    c.weighty    = 0.0;
    c.fill       = GridBagConstraints.NONE;
    add(pWyjscie,c);

    // Wypeniacz, dziki ktremu kolumna ma niezerow szeroko
    Component wypelniacz = Box.createRigidArea(new Dimension(1,1));
    c.gridx      = 1;
    c.weightx    = 1.0;
    add(wypelniacz,c);
  }

  public static void main(String[] argumenty) {
    NarzedziaOkienkowe.ustawWygladSystemowy();
    JFrame ramka = new JFrame("Test menedera rozmieszczenia GridBagLayout");
    ramka.setContentPane(new TestGridBagLayout());
    ramka.addWindowListener(new NasluchWyjscia());
    ramka.pack();
    ramka.setVisible(true);
  }
}