import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** Przykad wykorzystania menedera rozmieszczenia BoxLayout.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class TestBoxLayout extends JPanel
                           implements ActionListener{
  BoxLayout menedzer;
  JButton gornyPrzycisk, srodkowyPrzycisk, dolnyPrzycisk;

  public TestBoxLayout() {
    menedzer = new BoxLayout(this, BoxLayout.Y_AXIS);
    setLayout(menedzer);

    JLabel etykieta = new JLabel("Przykad menedera BoxLayout");

    gornyPrzycisk = new JButton("Do lewej krawdzi");
    srodkowyPrzycisk = new JButton("Centrowanie");
    dolnyPrzycisk = new JButton("Do prawej krawdzi");
    gornyPrzycisk.addActionListener(this);
    srodkowyPrzycisk.addActionListener(this);
    dolnyPrzycisk.addActionListener(this);

    add(etykieta);
    add(gornyPrzycisk);
    add(srodkowyPrzycisk);
    add(dolnyPrzycisk);
    setBackground(Color.white);
  }

  public void actionPerformed(ActionEvent zdarzenie) {
    if (zdarzenie.getSource() == gornyPrzycisk) {
      refresh(Component.LEFT_ALIGNMENT);
    } else if (zdarzenie.getSource() == srodkowyPrzycisk) {
      refresh(Component.CENTER_ALIGNMENT);
    } else if (zdarzenie.getSource() == dolnyPrzycisk) {
      refresh(Component.RIGHT_ALIGNMENT);
    }
  }

  private void refresh(float wyrownanie){
    gornyPrzycisk.setAlignmentX(wyrownanie);
    srodkowyPrzycisk.setAlignmentX(wyrownanie);
    dolnyPrzycisk.setAlignmentX(wyrownanie);
    revalidate();
    System.out.println("x: "+menedzer.getLayoutAlignmentX(this));
  }

  public static void main(String[] argumenty) {
    NarzedziaOkienkowe.ustawWygladSystemowy();
    NarzedziaOkienkowe.otworzWJFrame(new TestBoxLayout(), 300, 135,
                                 "TestBoxLayout");
  }
}