import java.awt.*;
import java.net.*;

/** Panel przedstawiajcy kart do gry. W tym oknie <B>nie</B> jest 
 *  wykorzystywany meneder CardLayout. Obiekty klasy PanelKarty s
 *  umieszczane w oknie z przykadu Karty, czyli w oknie nadrzdnym
 *  zarzdzajcym wywietlaniem obiektami PanelKarty.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class PanelKarty extends Panel {
  private Label nazwa;
  private ImageLabel rysunekKarty;

  public PanelKarty(String nazwaKarty,
                   URL katalog, String plikRysunku) {
    setLayout(new BorderLayout());
    nazwa = new Label(nazwaKarty, Label.CENTER);
    nazwa.setFont(new Font("SanSerif", Font.BOLD, 50));
    add(nazwa, BorderLayout.NORTH);
    rysunekKarty = new ImageLabel(katalog, plikRysunku);
    Panel panelRysunku = new Panel();
    panelRysunku.add(rysunekKarty);
    add(panelRysunku, BorderLayout.CENTER);
    setSize(getPreferredSize());
  }

  public Label dajNazwe() {
    return(nazwa);
  }

  public ImageLabel dajRysunek() {
    return(rysunekKarty);
  }
}