import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;

/** Przykad wykorzysatnia niewidocznych komponentw:
 *  stay obszar, klin i przylepiec
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
 */

public class NiewidoczneKomponenty extends JPanel {
  Component wypelniacz;

  public NiewidoczneKomponenty() {
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

    // Umieszczenie staego obszaru pomidzy dwoma przyciskami.
    // Wymiary komponentu: 20 x 75 pikseli
    JPanel p1= new JPanel();
    wypelniacz = Box.createRigidArea(new Dimension(20,75));
    przygotowaniePanelu(p1, "Stay obszar - 20x75 pikseli", wypelniacz);

    // Rozdzielenie dwch przyciskw za pomoc 60-pikselowego klina
    JPanel p2= new JPanel();
    wypelniacz = Box.createHorizontalStrut(60);
    przygotowaniePanelu(p2, "Poziomy klin - 60 pikseli", wypelniacz);

    // Poziomu komponent przylepca w menederze FlowLayout - bezuyteczny
    JPanel p3= new JPanel();
    wypelniacz = Box.createHorizontalGlue();
    przygotowaniePanelu(p3, "Poziomy przylepiec - meneder FlowLayout", wypelniacz);

    // Wypenienie pozostaej przestrzeni komponentem poziomego przylepca.
    // Komponent ten nie jest obsugiwany przez domylny meneder obiektu JPanel -
    // FlowLayout. Std konieczno zmiany menedera na BoxLayout.
    JPanel p4= new JPanel();
    p4.setLayout(new BoxLayout(p4,BoxLayout.X_AXIS));
    wypelniacz = Box.createHorizontalGlue();
    przygotowaniePanelu(p4, "Poziomy przylepiec - meneder BoxLayout", wypelniacz);

    add(p1);
    add(p2);
    add(p3);
    add(p4);
  }

  // Metoda pomocnicza definiujca obramowanie i dodajca komponenty
  private void przygotowaniePanelu(JPanel p, String tytul,
                          Component wypelniacz) {
    p.setBorder(BorderFactory.createTitledBorder(
                       BorderFactory.createEtchedBorder(),tytul,
                       TitledBorder.TOP,TitledBorder.CENTER));
    p.setBackground(Color.white);
    p.add(new JButton("Lewy"));
    p.add(wypelniacz);
    p.add(new JButton("Prawy"));
  }

  public static void main(String[] argumenty) {
    String tytul = "Wykorzystanie niewidocznych komponentw";
    NarzedziaOkienkowe.ustawWygladSystemowy();
    NarzedziaOkienkowe.otworzWJFrame(new NiewidoczneKomponenty(),
                                 350, 325, tytul);
  }
}