import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/** Przykad wykorzystania menedera rozmieszczenia CardLayout.
 *  W prawej czci okna znajduje si Panel, w ktrym meneder FlowLayout
 *  zarzdza czterema innymi panelami (kady z nich prezentuje
 *  rysunek karty do gry). Przyciski znajdujce si z lewej strony okna
 *  zmieniaj karty przez wywoywanie metod menedera rozmieszczenia.
 *
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class Karty extends Applet implements ActionListener {
  private Button pierwsza, ostatnia, poprzednia, nastepna;
  private String[] oznaczeniaKart = { "Walet","Krlowa","Krl","As" };
  private PanelKarty[] paneleKart = new PanelKarty[4];
  private CardLayout menedzer;
  private Panel panelWyswietlaniaKart;

  public void init() {
    setBackground(Color.white);
    setLayout(new BorderLayout());
    dodajPanelPrzyciskow();
    dodajPanelWyswietlaniaKart();
  }

  private void dodajPanelPrzyciskow() {
    Panel panelPrzyciskow = new Panel();
    panelPrzyciskow.setLayout(new GridLayout(9, 1));
    Font czcionkaPrzyciskow = new Font("SansSerif", Font.BOLD, 12);
    panelPrzyciskow.setFont(czcionkaPrzyciskow);
    for(int i=0; i<oznaczeniaKart.length; i++) {
      Button przycisk = new Button(oznaczeniaKart[i]);
      przycisk.addActionListener(this);
      panelPrzyciskow.add(przycisk);
    }
    pierwsza = new Button("Pierwsza");
    pierwsza.addActionListener(this);
    ostatnia = new Button("Ostatnia");
    ostatnia.addActionListener(this);
    poprzednia = new Button("Poprzednia");
    poprzednia.addActionListener(this);
    nastepna = new Button("Nastpna");
    nastepna.addActionListener(this);
    panelPrzyciskow.add(new Label("------------", Label.CENTER));
    panelPrzyciskow.add(pierwsza);
    panelPrzyciskow.add(ostatnia);
    panelPrzyciskow.add(poprzednia);
    panelPrzyciskow.add(nastepna);
    add(panelPrzyciskow, BorderLayout.WEST);
  }

  private void dodajPanelWyswietlaniaKart() {
    panelWyswietlaniaKart = new Panel();
    menedzer = new CardLayout();
    panelWyswietlaniaKart.setLayout(menedzer);
    String nazwaKarty;
    for(int i=0; i<oznaczeniaKart.length; i++) {
      nazwaKarty = oznaczeniaKart[i];
      paneleKart[i] =
        new PanelKarty(nazwaKarty, getCodeBase(),
                      "rysunki/" + nazwaKarty + ".gif");
      panelWyswietlaniaKart.add(paneleKart[i], nazwaKarty);
    }
    add(panelWyswietlaniaKart, BorderLayout.CENTER);
  }

  public void actionPerformed(ActionEvent zdarzenie) {
    Button zrodlo = (Button)zdarzenie.getSource();
    if (zrodlo == pierwsza)
      menedzer.first(panelWyswietlaniaKart);
    else if (zrodlo == ostatnia)
      menedzer.last(panelWyswietlaniaKart);
    else if (zrodlo == poprzednia)
      menedzer.previous(panelWyswietlaniaKart);
    else if (zrodlo == nastepna)
      menedzer.next(panelWyswietlaniaKart);
    else
      menedzer.show(panelWyswietlaniaKart, zrodlo.getLabel());
    return;
  }
}