import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/** Aplet umoliwiajcy krelenie linii.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class ProstaDeskaKreslarska extends Applet {
  protected int ostatniX=0, ostatniY=0;

  public void init() {
    setBackground(Color.white);
    setForeground(Color.blue);
    addMouseListener(new ZapisPozycji());
    addMouseMotionListener(new RysowanieLinii());
  }

  protected void zapis(int x, int y) {
    ostatniX = x;
    ostatniY = y;
  }

  // Zapisanie wsprzdnych wejcia kursora w okno apletu lub
  // pooenia kursora przy naciniciu przycisku myszy.
  
  private class ZapisPozycji extends MouseAdapter {
    public void mouseEntered(MouseEvent zdarzenie) {
      requestFocus(); // metoda wykorzystana w przyszym przykadzie
      zapis(zdarzenie.getX(), zdarzenie.getY());
    }

    public void mousePressed(MouseEvent zdarzenie) {
      zapis(zdarzenie.getX(), zdarzenie.getY());
    }
  }

  // Rysowanie linii pomidzy punktami, przez ktre
  // uytkownik przecign kursor.
  
  private class RysowanieLinii extends MouseMotionAdapter {
    public void mouseDragged(MouseEvent zdarzenie) {
      int x = zdarzenie.getX();
      int y = zdarzenie.getY();
      Graphics g = getGraphics();
      g.drawLine(ostatniX, ostatniY, x, y);
      zapis(x, y);
    }
  }
}
