import java.awt.*;
import java.awt.event.*;

/** Pole tekstowe poprawiajce bdy uytkownika przeznaczone do
 *  wprowadzania nazw jzykw programowania
 *  <P>
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class PoleJezyka extends TextField {
  private String[] podciagi =
    { "", "J", "Ja", "Jav", "Java" };

  public PoleJezyka() {
    addKeyListener(new PoprawianieBledow());
    addActionListener(new DokanczanieWyrazow());
    addFocusListener(new PrzekazPodprogowy());
  }

  // Umieszczenie kursora na kocu linii.
  
  private void ustawKursor() {
    setCaretPosition(5);
  }
  
  // Klasa nasuchu moniotorujca i poprawiajca tekst wprowadzony przez uytkownika.
  
  private class PoprawianieBledow extends KeyAdapter {
    public void keyTyped(KeyEvent zdarzenie) {
      ustawJezyk();
      ustawKursor();
    }

    // Wywietlenie fragmentu waciwej nazwy jzyka programowania, ktry
    // jest najbardziej zbliony do tekstu wprowadzonego przez uytkownika.
    
    private void ustawJezyk() {
      int dlugosc = getText().length();
      if (dlugosc <= 4) {
        setText(podciagi[dlugosc]);
      } else {
        setText("Java");
      }
      ustawKursor();
    }
  }

  // Klasa nasuchu zastpujca fragment wprowadzonej nazwy najbardziej  
  // zblion wartoci ze sownika.
  
  private class DokanczanieWyrazow implements ActionListener {

    // Wywietlenie poprawnej odpowiedzi w chwili gdy uytkownik nacinie Enter.
    
    public void actionPerformed(ActionEvent event) {
      setText("Java");
      ustawKursor();
    }
  }

  // Klasa nasuchu wywietlajca podpowied.
  
  private class PrzekazPodprogowy extends FocusAdapter {
    public void focusGained(FocusEvent zdarzenie) {
      String text = getText();
      for(int i=0; i<10; i++) {
        setText("Podpowied: Java");
        setText(text);
      }
    }
  }
}
