import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/** Ulepszona deska krelarska, pozwalajca dodatkowo
 *  na wprowadzanie tekstu.
 *  <P>
 * Kody zaczerpniete z polskiej edycji        *
 * ksiazki Serwisy internetowe. Programowanie *
 * Wydawnictwo Helion, Gliwice,               *
 * ftp://ftp.helion.pl/przyklady/serinp.zip   *
 * &copy; 2001 Marty Hall and Larry Brown;    *
*/

public class DeskaKreslarska extends ProstaDeskaKreslarska {
  protected FontMetrics fm;

  public void init() {
    super.init();
    Font czcionka = new Font("Serif", Font.BOLD, 20);
    setFont(czcionka);
    fm = getFontMetrics(czcionka);
    addKeyListener(new WyswietlenieZnaku());
  }

  private class WyswietlenieZnaku extends KeyAdapter {
    // Jeeli uytkownik wprowadzi drukowalny znak, jest on
    // wywietlany, po czym kursor jest przesuwany w prawo.
    
    public void keyTyped(KeyEvent zdarzenie) {
      String s = String.valueOf(zdarzenie.getKeyChar());
      getGraphics().drawString(s, ostatniX, ostatniY);
      zapis(ostatniX + fm.stringWidth(s), ostatniY);
    }
  }
}
